//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D3DF0244.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D3DF0244.cm

//## begin module%3D86D3DF0244.cp preserve=no
//## end module%3D86D3DF0244.cp

//## Module: Thread%3D86D3DF0244; Pseudo Package body
//## Source file: C:\Program Files\Rational\Rose\C++\source\Thread.cpp

//## begin module%3D86D3DF0244.additionalIncludes preserve=no
//## end module%3D86D3DF0244.additionalIncludes

//## begin module%3D86D3DF0244.includes preserve=yes
//## end module%3D86D3DF0244.includes

// Thread
#include "Thread.h"
//## begin module%3D86D3DF0244.additionalDeclarations preserve=yes
//## end module%3D86D3DF0244.additionalDeclarations


// Class Thread
Thread::Thread (char* name, int stackSize, int priority, int id)
  //## begin Thread::Thread%3D99171A00F0.hasinit preserve=no
  //## end Thread::Thread%3D99171A00F0.hasinit
  //## begin Thread::Thread%3D99171A00F0.initialization preserve=yes
  //## end Thread::Thread%3D99171A00F0.initialization
{
  //## begin Thread::Thread%3D99171A00F0.body preserve=yes
  this->name = "name";
  //should be: this->name = name. But what if the name the char* is pointing to doesn't exist anymore when we call spawn???
	this->stackSize = stackSize;
	this->priority = priority;
	this->id = id;
  //## end Thread::Thread%3D99171A00F0.body
}


/*???Thread::~Thread()
{
  //## begin Thread::~Thread%3D86D3DF0244_dest.body preserve=yes
	kill();
  //## end Thread::~Thread%3D86D3DF0244_dest.body
}*/



//## Other Operations (implementation)
bool Thread::spawn ()
{
  //## begin Thread::spawn%3D9021FB00DC.body preserve=yes
	threadControlBlock = OSSpawn(name, run, stackSize, priority, id);
	if (threadControlBlock)
		return true;
	else
		return false;
  //## end Thread::spawn%3D9021FB00DC.body
}

void Thread::ready ()
{
  //## begin Thread::ready%3D9021F30104.body preserve=yes
	if (threadControlBlock)
		OSReady(threadControlBlock);
  //## end Thread::ready%3D9021F30104.body
}

void Thread::reschedule ()
{
  //## begin Thread::reschedule%3D902212000A.body preserve=yes
	OSReschedule();
  //## end Thread::reschedule%3D902212000A.body
}

void Thread::sleep (int hundredthSeconds)
{
  //## begin Thread::sleep%3D9022160352.body preserve=yes
	OSSleep(hundredthSeconds);
  //## end Thread::sleep%3D9022160352.body
}

void Thread::suspend ()
{
  //## begin Thread::suspend%3D90220202E4.body preserve=yes
	if (threadControlBlock)
		OSSuspend(threadControlBlock);
  //## end Thread::suspend%3D90220202E4.body
}

void Thread::kill ()
{
  //## begin Thread::kill%3D9021F7024E.body preserve=yes
	//if kill is called by Thread destructor, does it really need to be public??
	if (threadControlBlock)
		OSKill(threadControlBlock);
  //## end Thread::kill%3D9021F7024E.body
}

void Thread::run ()
{
  //## begin Thread::run%3D99136F000A.body preserve=yes
  while(1)
  {
    LCDPrintf("'run' method of 'Thread' base class started\n");
  }
  //## end Thread::run%3D99136F000A.body
}

// Additional Declarations
  //## begin Thread%3D86D3DF0244.declarations preserve=yes
  //## end Thread%3D86D3DF0244.declarations

//## begin module%3D86D3DF0244.epilog preserve=yes
//## end module%3D86D3DF0244.epilog
