#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

//  Generate a random maze of uniform size
//
//  Mazes generated conform to the following criteria:
//
//  - Ball lies at the top of the room
//  - Robot starting position 

int main(int argc, char** argv)
{
	int i,j, p;
	int width, height;
	int w, h;
	int x, y, o;
	char** mazearray;

	srand(time(NULL));

	if(argc != 4) {
		printf("Usage: MazeGen <maze filename> <width> <height>\n");
		return 0;
	}

	//  Add an extra space in the width for \n
	width = atoi(argv[2]) +1;
	height = atoi(argv[3]);

	printf("Generating maze size %d x %d\n", width, height);

	ofstream ofs(argv[1]);
	if(!ofs) {
		printf("Error opening file %s for writing\n", argv[1]);
		return 0;
	}

	//  mazearray is allocated, row major order
	mazearray = (char**) calloc(height, sizeof(char*));
	for(i=0; i<height; i++)
		mazearray[i] = (char*) calloc(width, sizeof(char));

	//  Fill the inside
	for(j=0; j<height-1; j++)
		for(i=1; i<width-1; i++)
			mazearray[j][i] = ' ';

	//  Draw the walls
	mazearray[0][0] = ' ';
	for(i=1; i<width-1; i++)
		mazearray[0][i] = '_';
	mazearray[0][width-2] = ' ';
	mazearray[0][width-1] = '\n';

	for(i=1; i<height; i++) {
		mazearray[i][0] = '|';
		mazearray[i][width-2] = '|';
		mazearray[i][width-1] = '\n';
	}

	for(i=1; i<width-2; i++) {
		mazearray[height-1][i] = '_';
	}
	mazearray[height-1][width-1] = '\n';

	//  Select a spot for the robot to start in
	
	// x position anywhere in the maze but has to be odd
	x = rand() % (width-3) + 1;
	if(x % 2 == 0) {
		x = (x+1 >= width-2) ? x-1 : x+1;
	}

	// y position lower half
	y = (rand() % (height / 2)) + height/2;
	// orientation: 
	o = rand() % 4;
	switch(o) {
		case 0:
			mazearray[y][x] = (y==height-1) ? 'S' : 's';
			break;
		case 1:
			mazearray[y][x] = (y==height-1) ? 'L': 'l';
			break;
		case 2:
			mazearray[y][x] = (y==height-1) ? 'R': 'r';
			break;
		case 3:
			mazearray[y][x] = (y==height-1) ? 'D': 'd';
			break;
	}

	//  Put the ball in the top quarter somewhere oddcol
	x = rand() % (width-3) + 1;
	if(x % 2 == 0) {
		x = (x+1 >= width-2) ? x-1 : x+1;
	}

	y = rand() % ((height-1) / 4) + 2;
	mazearray[y][x] = 'o';

	//  Write out the maze
	for(i=0; i<height; i++) {
		for(j=0; j<width; j++) {
			if(mazearray[i][j] != 0)
				ofs << mazearray[i][j];
		}
	}

	ofs << "360";
	ofs.close();

	for(i=0; i<height; i++)
		free(mazearray[i]);

	free(mazearray);

}
