
/************************************************************************** *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2002 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef SO_ROTATEDISCDRAGGER_IV_H
#define SO_ROTATEDISCDRAGGER_IV_H

static const char ROTATEDISCDRAGGER_draggergeometry[] =
  "#Inventor V2.1 ascii\n"
  "\n"
  "\n"
  "DEF ROTATEDISC_INACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0.5  emissiveColor 0.5 0.5 0.5 }\n"
  "DEF ROTATEDISC_ACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0  emissiveColor 0.5 0.5 0 }\n"
  "DEF ROTATEDISC_FEEDBACK_MATERIAL Material { diffuseColor 0.5 0 0.5  emissiveColor 0.5 0 0.5 }\n"
  "\n"
  "\n"
  "DEF ROTATEDISC_CYLINDER Separator {\n"
  "   DrawStyle { style LINES }\n"
  "   Rotation { rotation 1 0 0  1.57 }\n"
  "   Scale { scaleFactor 1.733 1 1.733 }\n"
  "   ShapeHints { vertexOrdering UNKNOWN_ORDERING }\n"
  "   Cylinder { parts SIDES height 0.2 }\n"
  "}\n"
  "\n"
  "DEF ROTATEDISC_BOX Cube { width 2.2  height 2.2  depth 2.2 }\n"
  "\n"
  "DEF rotateDiscRotator Separator {\n"
  "   USE ROTATEDISC_INACTIVE_MATERIAL\n"
  "   USE ROTATEDISC_CYLINDER\n"
  "\n"
  "   DrawStyle { style INVISIBLE }\n"
  "   USE ROTATEDISC_BOX\n"
  "}\n"
  "\n"
  "DEF rotateDiscRotatorActive Separator {\n"
  "   USE ROTATEDISC_ACTIVE_MATERIAL\n"
  "   USE ROTATEDISC_CYLINDER\n"
  "   DrawStyle { style LINES  lineWidth 1 }\n"
  "   USE ROTATEDISC_BOX\n"
  "}\n"
  "\n"
  "DEF ROTATEDISC_AXIS_LINE Group {\n"
  "   Coordinate3 { point [ 0 0 1.1, 0 0 -1.1 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "}\n"
  "\n"
  "DEF rotateDiscFeedback Separator {\n"
  "   USE ROTATEDISC_FEEDBACK_MATERIAL\n"
  "   USE ROTATEDISC_AXIS_LINE\n"
  "}\n"
  "\n"
  "DEF rotateDiscFeedbackActive Separator {\n"
  "   USE ROTATEDISC_FEEDBACK_MATERIAL\n"
  "   USE ROTATEDISC_AXIS_LINE\n"
  "}\n";

#endif /* ! SO_ROTATEDISCDRAGGER_IV_H */
