
/************************************************************************** *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2002 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef SO_TRANSLATE2DRAGGER_IV_H
#define SO_TRANSLATE2DRAGGER_IV_H

static const char TRANSLATE2DRAGGER_draggergeometry[] =
  "#Inventor V2.1 ascii\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSLATE2_INACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0.5  emissiveColor 0.5 0.5 0.5 }\n"
  "DEF TRANSLATE2_ACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0  emissiveColor 0.5 0.5 0 }\n"
  "\n"
  "\n"
  "DEF TRANSLATE2_GEOM Separator {\n"
  "\n"
  "   Cube { width 2  height 0.1  depth 0.1 } # Horizontal\n"
  "   Cube { width 0.1  height 2  depth 0.1 } # Vertical\n"
  "\n"
  "   Separator {\n"
  "      Translation { translation 1.25 0 0 }\n"
  "      RotationXYZ { axis Z  angle -1.57 }\n"
  "      DEF TRANSLATE2_ARROWHEAD Cone { height 0.5  bottomRadius 0.25 }\n"
  "   }\n"
  "\n"
  "   Separator {\n"
  "      Translation { translation -1.25 0 0 }\n"
  "      RotationXYZ { axis Z  angle 1.57 }\n"
  "      USE TRANSLATE2_ARROWHEAD\n"
  "   }\n"
  "\n"
  "   Separator {\n"
  "      Translation { translation 0 1.25 0 }\n"
  "      USE TRANSLATE2_ARROWHEAD\n"
  "   }\n"
  "\n"
  "   Separator {\n"
  "      Translation { translation 0 -1.25 0 }\n"
  "      RotationXYZ { axis X  angle 3.14 }\n"
  "      USE TRANSLATE2_ARROWHEAD\n"
  "   }\n"
  "}\n"
  "\n"
  "DEF translate2Translator Separator {\n"
  "   USE TRANSLATE2_INACTIVE_MATERIAL\n"
  "   USE TRANSLATE2_GEOM\n"
  "}\n"
  "\n"
  "DEF translate2TranslatorActive Separator {\n"
  "   USE TRANSLATE2_ACTIVE_MATERIAL\n"
  "   USE TRANSLATE2_GEOM\n"
  "}\n"
  "\n"
  "DEF translate2Feedback Separator { }\n"
  "DEF translate2FeedbackActive Separator { }\n"
  "\n"
  "DEF translate2XAxisFeedback Separator {\n"
  "  USE TRANSLATE2_ACTIVE_MATERIAL\n"
  "  DrawStyle { lineWidth 2 }\n"
  "  Coordinate3 { point [ -3 0 0, 3 0 0 ] }\n"
  "  LineSet { }\n"
  "}\n"
  "DEF translate2YAxisFeedback Separator {\n"
  "  USE TRANSLATE2_ACTIVE_MATERIAL\n"
  "  DrawStyle { lineWidth 2 }\n"
  "  Coordinate3 { point [ 0 -3 0, 0 3 0 ] }\n"
  "  LineSet { }\n"
  "}\n";

#endif /* ! SO_TRANSLATE2DRAGGER_IV_H */
