/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2002 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SBSPHERESHEETPROJECTOR_H
#define COIN_SBSPHERESHEETPROJECTOR_H

#include <Inventor/projectors/SbSphereProjector.h>
#include <Inventor/SbPlane.h>

class COIN_DLL_API SbSphereSheetProjector : public SbSphereProjector {
  typedef SbSphereProjector inherited;

public:
  SbSphereSheetProjector(const SbBool orienttoeye = TRUE);
  SbSphereSheetProjector(const SbSphere & sph, const SbBool orienttoeye = TRUE);

  virtual SbProjector * copy(void) const;
  virtual SbVec3f project(const SbVec2f & point);
  virtual SbRotation getRotation(const SbVec3f & point1,
                                 const SbVec3f & point2);

protected:
  void setupPlane(void);

  SbVec3f workingProjPoint;
  SbVec3f planePoint;
  SbVec3f planeDir;
  float planeDist;
  SbPlane tolPlane;
};

#endif // !COIN_SBSPHERESHEETPROJECTOR_H
