#! /bin/sh

qdir=`echo $0 | sed -e 's/\/[^\/]*$//'`

for patch in $qdir/[0-9]*.diff; do
  patchfilename=`echo $patch | sed "s#^$qdir/##"`
  summary=`grep ^Summary: $patch | sed 's/^Summary: //'`
  status=`grep ^Status: $patch | sed 's/^Status: //'`
  severity=`grep ^Severity: $patch | sed 's/^Severity: //'`
  case $status in
  stable)
    case $severity in
    bugfix | optimization | rewrite)
      if ( cd $qdir/..; patch -p0 --dry-run <patchqueue/$patchfilename >/dev/null 2>&1 ); then
        echo "It's safe to apply $patchfilename"
      else
        echo "It's safe to apply $patchfilename, but there's something wrong with the patch"
      fi
      ;;
    extension)
      if ( cd $qdir/..; patch -p0 --dry-run <patchqueue/$patchfilename >/dev/null 2>&1 ); then
        echo "Wait with $patchfilename until next minor release"
      else
        echo "Wait with $patchfilename until next minor release - check patch validity"
      fi
      ;;
    esac
    ;;
  unstable | untested)
    case $severity in
    bugfix | optimization | rewrite)
      if ( cd $qdir/..; patch -p0 --dry-run <patchqueue/$patchfilename >/dev/null 2>&1 ); then
        echo "More testing required for $patchfilename"
      else
        echo "More testing required for $patchfilename, but there's something wrong with the patch"
      fi
      ;;
    extension)
      if ( cd $qdir/..; patch -p0 --dry-run <patchqueue/$patchfilename >/dev/null 2>&1 ); then
        echo "Wait with $patchfilename until next minor release"
      else
        echo "Wait with $patchfilename until next minor release - check patch validity"
      fi
      ;;
    esac
    ;;
  esac
done

