/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2002 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

// Important note: this sourcefile was mostly generated by the
// Coin/scripts/templant script from the code in MFNodeEnginePath.tpl,
// only the notify() method is specific for SoMFPath.cpp.

//$ BEGIN TEMPLATE MFNodeEnginePath(PATH, Path, path)

/*!
  \class SoMFPath SoMFPath.h Inventor/fields/SoMFPath.h
  \brief The SoMFPath class is a container for paths.
  \ingroup fields

  This field container stores an array of pointers to paths. It takes
  care of the necessary functionality for handling copy, import and
  export operations.

  Note that path pointers stored in field instances of this type may
  be \c NULL pointers.

  \sa SoPath, SoSFPath

*/

// Type-specific define to be able to do #ifdef tests on type.  (Note:
// used to check the header file wrapper define, but that doesn't work
// with --enable-compact build.)
#define COIN_INTERNAL_PATH

#include <Inventor/fields/SoMFPath.h>
#include <Inventor/fields/SoSubFieldP.h>
#include <Inventor/fields/SoSFPath.h>
#include <Inventor/SoOutput.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/SoPath.h>
#include <Inventor/engines/SoEngine.h>
#include <Inventor/nodes/SoNode.h>
#if COIN_DEBUG
#include <Inventor/errors/SoDebugError.h>
#endif // COIN_DEBUG


SO_MFIELD_REQUIRED_SOURCE(SoMFPath);
SO_MFIELD_CONSTRUCTOR_SOURCE(SoMFPath);
SO_MFIELD_MALLOC_SOURCE(SoMFPath, SoPath *);



// Override from parent class.
void
SoMFPath::initClass(void)
{
  SO_MFIELD_INTERNAL_INIT_CLASS(SoMFPath);
}


// No need to document readValue() and writeValue() here, as the
// necessary information is provided by the documentation of the
// parent classes.
#ifndef DOXYGEN_SKIP_THIS

//// From the SO_MFIELD_VALUE_SOURCE macro, start. ///////////////////////////

// We can't use the macro invocation, as we need to take care of doing
// ref() and unref() on the paths in the array.

int
SoMFPath::fieldSizeof(void) const
{
  return sizeof(SoPath *);
}

void *
SoMFPath::valuesPtr(void)
{
  return (void *)this->values;
}

void
SoMFPath::setValuesPtr(void * ptr)
{
  // We don't get any ref()'ing done here, or any notification
  // mechanisms set up -- so this function should _only_ be used for
  // initial setup of array memory.  In Coin, it's only used from
  // SoMField::allocValues().
  this->values = (SoPath **)ptr;
}

int
SoMFPath::find(SoPath * value, SbBool addifnotfound)
{
  for (int i=0; i < this->num; i++) if ((*this)[i] == value) return i;

  if (addifnotfound) this->set1Value(this->num, value);
  return -1;
}

void
SoMFPath::setValues(const int start, const int num, const SoPath ** newvals)
{
  // Disable temporarily, so we under any circumstances will not send
  // more than one notification about the changes.
  SbBool notificstate = this->enableNotify(FALSE);

  // ref() new paths before unref()-ing old ones, in case there are
  // common paths (we don't want any premature destruction to happen).
  { for (int i=0; i < num; i++) if (newvals[i]) newvals[i]->ref(); }

  // We favor simplicity of code over performance here.
  { for (int i=0; i < num; i++)
    this->set1Value(start+i, (SoPath *)newvals[i]); }

  // unref() to match the initial ref().
  { for (int i=0; i < num; i++) if (newvals[i]) newvals[i]->unref(); }

  // Finally, send notification.
  (void)this->enableNotify(notificstate);
  if (notificstate) this->valueChanged();
}

void
SoMFPath::set1Value(const int idx, SoPath * newval)
{
  // Disable temporarily, so we under no circumstances will send more
  // than one notification about the change.
  SbBool notificstate = this->enableNotify(FALSE);

  // Don't use getNum(), getValues() or operator[] to find old values,
  // since this might trigger a recursive evaluation call if the field 
  // is connected.

  // Expand array if necessary.
  if (idx >= this->num) {
#ifdef COIN_INTERNAL_PATH
    for (int i = this->num; i <= idx; i++) this->pathheads.append(NULL);
#endif // COIN_INTERNAL_PATH
    this->setNum(idx + 1);
  }

  SoPath * oldptr = this->values[idx];
  if (oldptr == newval) return;

  if (oldptr) {
    oldptr->removeAuditor(this, SoNotRec::FIELD);
    oldptr->unref();
#ifdef COIN_INTERNAL_PATH
    SoNode * h = oldptr->getHead();
    // The path should be audited by us at all times. So don't use
    // SoMFPath to wrap SoTempPath or SoLightPath, for instance.
    assert(h==this->pathheads[idx] &&
           "Path head changed without notification!");
    if (h) {
      h->removeAuditor(this, SoNotRec::FIELD);
      h->unref();
    }
#endif // COIN_INTERNAL_PATH
  }

  if (newval) {
    newval->addAuditor(this, SoNotRec::FIELD);
    newval->ref();
#ifdef COIN_INTERNAL_PATH
    SoNode * h = newval->getHead();
    if (h) {
      h->addAuditor(this, SoNotRec::FIELD);
      h->ref();
    }
#endif // COIN_INTERNAL_PATH
  }

  this->values[idx] = newval;
#ifdef COIN_INTERNAL_PATH
  this->pathheads[idx] = newval ? newval->getHead() : NULL;
#endif // COIN_INTERNAL_PATH

  // Finally, send notification.
  (void)this->enableNotify(notificstate);
  if (notificstate) this->valueChanged();
}

void
SoMFPath::setValue(SoPath * value)
{
  this->deleteAllValues();
  this->set1Value(0, value);
}

SbBool
SoMFPath::operator==(const SoMFPath & field) const
{
  if (this == &field) return TRUE;
  if (this->getNum() != field.getNum()) return FALSE;

  const SoPath ** const lhs = this->getValues(0);
  const SoPath ** const rhs = field.getValues(0);
  for (int i = 0; i < num; i++) if (lhs[i] != rhs[i]) return FALSE;
  return TRUE;
}

void
SoMFPath::deleteAllValues(void)
{
  // Don't use getNum(), but use this->num directly, since getNum() 
  // might trigger a recursive evaluation call if the field 
  // is connected.

  if (this->num) this->deleteValues(0);
}

// Overridden to handle unref() and removeAuditor().
void
SoMFPath::deleteValues(int start, int num)
{
  // Note: this function overrides the one in SoMField, so if you do
  // any changes here, take a look at that method aswell.

  if (num == -1) num = this->num - start;
  for (int i=start; i < start+num; i++) {
    SoPath * n = this->values[i];
    if (n) {
      n->removeAuditor(this, SoNotRec::FIELD);
      n->unref();
    }
#ifdef COIN_INTERNAL_PATH
    SoNode * h = this->pathheads[start];
    this->pathheads.remove(start);
    if (h) {
      h->removeAuditor(this, SoNotRec::FIELD);
      h->unref();
    }
#endif // COIN_INTERNAL_PATH
  }

  inherited::deleteValues(start, num);
}

// Overridden to insert NULL pointers in new array slots.
void
SoMFPath::insertSpace(int start, int num)
{
  // Disable temporarily so we don't send notification prematurely
  // from inherited::insertSpace().
  SbBool notificstate = this->enableNotify(FALSE);

  inherited::insertSpace(start, num);
  for (int i=start; i < start+num; i++) {
#ifdef COIN_INTERNAL_PATH
    this->pathheads.insert(NULL, start);
#endif // COIN_INTERNAL_PATH
    this->values[i] = NULL;
  }

  // Initialization done, now send notification.
  (void)this->enableNotify(notificstate);
  if (notificstate) this->valueChanged();
}

// This is the "memmove replacement" to use copy constructors where
// they are defined.
void
SoMFPath::copyValue(int to, int from)
{
  this->values[to] = this->values[from];
}

//// From the SO_MFIELD_VALUE_SOURCE macro, end. /////////////////////////////


// Import a single path.
SbBool
SoMFPath::read1Value(SoInput * in, int index)
{
  SoSFPath sfpath;
  SbBool result = sfpath.readValue(in);
  if (result) this->set1Value(index, sfpath.getValue());
  return result;
}

// Export a single path.
void
SoMFPath::write1Value(SoOutput * out, int idx) const
{
  // NB: This code is common for SoMFNode, SoMFPath and SoMFEngine.
  // That's why we check for the base type before writing.

  SoBase * base = (SoBase*) this->values[idx];
  if (base) {
    if (base->isOfType(SoNode::getClassTypeId())) {
      ((SoNode*)base)->writeInstance(out);
    }
    else if (base->isOfType(SoPath::getClassTypeId())) {
      SoWriteAction wa(out);
      wa.continueToApply((SoPath*)base);
    }
    else if (base->isOfType(SoEngine::getClassTypeId())) {
      ((SoEngine*)base)->writeInstance(out);
    }
  }
  else {
    out->write("NULL");
  }
}

#endif // DOXYGEN_SKIP_THIS


// Overridden from parent to propagate write reference counting to
// path.
void
SoMFPath::countWriteRefs(SoOutput * out) const
{
  inherited::countWriteRefs(out);

  for (int i = 0; i < this->getNum(); i++) {
    SoBase * base = this->values[i];
    if (base) {
      // NB: This code is common for SoMFNode, SoMFPath and SoMFEngine.
      // That's why we check the base type before writing/counting

      if (base->isOfType(SoNode::getClassTypeId())) {
        ((SoNode*)base)->writeInstance(out);
      }
      else if (base->isOfType(SoEngine::getClassTypeId())) {
        ((SoEngine*)base)->addWriteReference(out);
      }
      else if (base->isOfType(SoPath::getClassTypeId())) {
        SoWriteAction wa(out);
        wa.continueToApply((SoPath*)base);
      }
    }
  }
}

// Override from parent to update our path pointer references. This is
// necessary so 1) we're added as an auditor to the copied paths (they
// have so far only been copied as pointer bits), and 2) so we
// increase the reference count.
void
SoMFPath::fixCopy(SbBool copyconnections)
{
  for (int i=0; i < this->getNum(); i++) {
    SoPath * n = (*this)[i];
    if (n) {
      // There's only been a bitwise copy of the pointer; no auditing
      // has been set up, no increase in the reference count. So we do
      // that by setting the value to NULL and then re-setting with
      // setValue().
      this->values[i] = NULL;
#if defined(COIN_INTERNAL_NODE) || defined(COIN_INTERNAL_ENGINE)
      SoFieldContainer * fc = SoFieldContainer::findCopy(n, copyconnections);
      this->set1Value(i, (SoPath *)fc);
#endif // COIN_INTERNAL_NODE || COIN_INTERNAL_ENGINE

#ifdef COIN_INTERNAL_PATH
      this->set1Value(i, n->copy());
#endif // COIN_INTERNAL_PATH
    }
  }
}

// Override from SoField to check path pointer.
SbBool
SoMFPath::referencesCopy(void) const
{
  if (inherited::referencesCopy()) return TRUE;

  for (int i=0; i < this->getNum(); i++) {
    SoPath * item = (*this)[i];
    if (item) {
#if defined(COIN_INTERNAL_NODE) || defined(COIN_INTERNAL_ENGINE)
      if (SoFieldContainer::checkCopy((SoFieldContainer *)item)) return TRUE;
#endif // COIN_INTERNAL_NODE || COIN_INTERNAL_ENGINE
#ifdef COIN_INTERNAL_PATH
      if (item->getHead() && SoFieldContainer::checkCopy(item->getHead())) return TRUE;
#endif // COIN_INTERNAL_PATH
    }
  }

  return FALSE;
}

// Kill the type-specific define.
#undef COIN_INTERNAL_PATH
//$ END TEMPLATE MFNodeEnginePath


// Overridden from superclass to handle changes in paths.
void
SoMFPath::notify(SoNotList * l)
{
  // Detect if any of our paths have gotten a new head :^), and if so
  // do the necessary audit setup magic.
  for (int i=0; i < this->getNum(); i++) {
    SoPath * p = (*this)[i];
    SoNode * oldhead = this->pathheads[i];
    if (p && p->getHead() != oldhead) {
      if (oldhead) {
        oldhead->removeAuditor(this, SoNotRec::FIELD);
        oldhead->unref();
      }
      SoNode * newhead = this->pathheads[i] = p->getHead();
      if (newhead) {
        newhead->addAuditor(this, SoNotRec::FIELD);
        newhead->ref();
      }
    }
  }

  inherited::notify(l);
}
