/**************************************************************************\
 *
 *  This file is part of the Coin family of 3D visualization libraries.
 *  Copyright (C) 1998-2002 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and / or
 *  modify it under the terms of the GNU General Public License
 *  version 2 as published by the Free Software Foundation.  See the
 *  file LICENSE.GPL at the root directory of this source distribution
 *  for more details.
 *
 *  If you desire to use this library in software that is incompatible
 *  with the GNU GPL, and / or you would like to take advantage of the
 *  additional benefits with regard to our support services, please
 *  contact Systems in Motion about acquiring a Coin Professional
 *  Edition License.  See <URL:http://www.coin3d.org> for more
 *  information.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  <URL:http://www.sim.no>, <mailto:support@sim.no>
 *
\**************************************************************************/

// src/Inventor/Qt/SoAny.h.  Generated from SoAny.h.in by configure.

#ifndef SOANY_H
#define SOANY_H

// This file contains definitions which should _only_ be used during
// library build. It is not installed for use by the application
// programmer.
#ifndef SOQT_INTERNAL
#error Only for internal use during library build.
#endif /* !SOQT_INTERNAL */

// ************************************************************************

#include <Inventor/SbPList.h>
#include <Inventor/Qt/SoQt.h>

// ************************************************************************

class SoAny {
public:
  // use the singleton design pattern for access
  static SoAny * si(void);

  const char * getenv(const char * e);

  void * getSharedGLContext(void * display, void * screen);
  void registerGLContext(void * context, void * display, void * screen);
  void unregisterGLContext(void * context);
  int getSharedCacheContextId(void * context);

  SoQt::FatalErrorCB * setFatalErrorHandler(SoQt::FatalErrorCB * cb,
                                               void * userdata);
  SbBool invokeFatalErrorHandler(SbString errmsg, SoQt::FatalErrors errcode);


  typedef void InternalFatalErrorCB(void * userdata);
  void addInternalFatalErrorHandler(SoAny::InternalFatalErrorCB * cb,
                                    void * ud);

private:
  SoAny(void);
  ~SoAny();
  static void cleanup_si(void);

  // (use SbPList instances to be able to compile properly on SGI /
  // TGS Inventor aswell as Coin)
  SbPList cclist;
  SbPList internalfehandlers, internalfedata;

  SoQt::FatalErrorCB * fatalcb;
  void * userdata;
}; // class SoAny

// ************************************************************************

#endif // ! SOANY_H
