/**************************************************************************\
 *
 *  This file is part of the Coin family of 3D visualization libraries.
 *  Copyright (C) 1998-2002 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and / or
 *  modify it under the terms of the GNU General Public License
 *  version 2 as published by the Free Software Foundation.  See the
 *  file LICENSE.GPL at the root directory of this source distribution
 *  for more details.
 *
 *  If you desire to use this library in software that is incompatible
 *  with the GNU GPL, and / or you would like to take advantage of the
 *  additional benefits with regard to our support services, please
 *  contact Systems in Motion about acquiring a Coin Professional
 *  Edition License.  See <URL:http://www.coin3d.org> for more
 *  information.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  <URL:http://www.sim.no>, <mailto:support@sim.no>
 *
\**************************************************************************/

#ifndef SOQT_INTERNALDEFS_H
#define SOQT_INTERNALDEFS_H

/* ********************************************************************** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* ********************************************************************** */

#ifdef __FILE__
#define SOQT_STUB_FILE __FILE__
#else
/* FIXME: avoid this case by redefining the compilation rules to define the
   current filename in some variable.  [20010919 larsa] */
#define SOQT_STUB_FILE ((char *)0L)
#endif

#ifdef __LINE__
#define SOQT_STUB_LINE __LINE__
#else
#define SOQT_STUB_LINE 0
#endif

#if HAVE_VAR___PRETTY_FUNCTION__
#define SOQT_STUB_FUNC __PRETTY_FUNCTION__
#else
#if HAVE_VAR___FUNCTION__
#define SOQT_STUB_FUNC __FUNCTION__
#else
#if HAVE_VAR___func__
#define SOQT_STUB_FUNC __func__
#else
#define SOQT_STUB_FUNC ((char *)0L)
#endif
#endif
#endif

#if SOQT_DEBUG

#include <Inventor/errors/SoDebugError.h>

/*
  This stupid thing is here to silence some compilers that complain on
  constant if-expressions.
*/

inline int soqt_not_null(const void * arg) { return (arg != NULL) ? 1 : 0; }


/* Collects common code from SOQT_STUB(), SOQT_STUB()_ONCE and
   SOQT_OBSOLETED(). */

#define SOQT_FUNCTIONIDENTIFIER(SOQTSTR) \
    SbString SOQTSTR(soqt_not_null(SOQT_STUB_FILE) ? SOQT_STUB_FILE : ""); \
    if (SOQTSTR.getLength() > 0) { SOQTSTR += ':'; } \
    SOQTSTR += SbString((int)SOQT_STUB_LINE); SOQTSTR += ':'; \
    SOQTSTR += soqt_not_null(SOQT_STUB_FUNC) ? SOQT_STUB_FUNC : ""

/*
  SOQT_STUB(): a macro that prints out stub information.
  Used where there is functionality missing.
*/

#define SOQT_STUB() \
  do { \
    SOQT_FUNCTIONIDENTIFIER(s); \
    SoDebugError::postWarning(s.getString(), \
                              "STUB: functionality not yet completed"); \
  } while (0)

/*
  SOQT_STUB_ONCE(): a macro that prints out stub information, but only on
  the first pass.  Used where there is functionality missing that may be
  called hundreds of times.
*/

#define SOQT_STUB_ONCE() \
  do { \
    static int first = 1; \
    if (first) { \
      SOQT_FUNCTIONIDENTIFIER(s); \
      SoDebugError::postWarning(s.getString(), \
                                "STUB: functionality not yet completed " \
                                "(first and last warning)"); \
      first = 0; \
    } \
  } while (0)

/*
  SOQT_OBSOLETED(): a macro that prints out information about an obsoleted
  function still being in use.
*/

#define SOQT_OBSOLETED() \
  do { \
    SOQT_FUNCTIONIDENTIFIER(s); \
    SoDebugError::post(s.getString(), \
                       "OBSOLETED: functionality no longer supported"); \
  } while (0)

#else /* !SOQT_DEBUG */

/* snub the stubs */
#define SOQT_STUB()      do { } while (0)
#define SOQT_STUB_ONCE() do { } while (0)
#define SOQT_OBSOLETED() do { } while (0)

#endif /* !SOQT_DEBUG */

/*
  GETTEXT support
*/

#if defined(ENABLE_NLS) && defined(HAVE_GETTEXT)
#include <libintl.h>
#define _(String) dgettext (PACKAGE, String)
#define N_(String) (String)
#else
#define _(String) (String)
#define N_(String) (String)
#endif /* HAVE_GETTEXT && ENABLE_NLS */

/* ********************************************************************** */

#endif /* ! SOQT_INTERNALDEFS_H */
