dnl Copyright (C) 1999-2001 Open Source Telecom Corporation.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_LIB_PTHREAD,
[
  AC_REQUIRE([OST_SYS_POSIX])
  AC_REQUIRE([OST_HEADER_SYSTIME])
  THREAD_FLAGS=""
  THREAD_LIBS=""
  ost_cv_thread_library="none"

  AC_ARG_WITH(pthread, [  --with-pthread[=lib]    using specified pthread library],
	[if test "$withval" != "" ; then ost_cv_thread_library=$withval ; fi]
  )

  AC_ARG_WITH(linuxthreads, [  --with-linuxthreads     use linux kernel mode library],
	[ost_cv_thread_library=lthread
	AC_DEFINE(WITH_LINUXTHREADS)
	if test "$withval" != "yes" ; then
		CXXFLAGS="-D__USE_GNU -D__USE_UNIX98 -I$withval $CXXFLAGS"
		CFLAGS="-D__USE_GNU -D__USE_UNIX98 -I$withval $CFLAGS"
	else
		CXXFLAGS="-D__USE_GNU -D__USE_UNIX98 -I/usr/local/include/pthread/linuxthreads $CXXFLAGS"
		CFLAGS="-D__USE_GNU -D__USE_UNIX98 -I/usr/local/include/pthread/linuxthreads $CFLAGS"
	fi
	])

  AC_CHECK_HEADERS(features.h)
  AC_CHECK_HEADERS(pthread.h, [
	AC_DEFINE(HAVE_PTHREAD_H)
	ost_cv_posix_threads=yes],
	ost_cv_posix_threads=no)

  if test $ost_cv_posix_threads = no ; then
	AC_TRY_COMPILE([#include pthread.h>],[],
		ost_cv_posix_threads=yes)
  fi

  ost_cv_posix_atomic=no
  AC_CHECK_HEADERS([sys/atomic.h],
	ost_cv_posix_sys_atomic=yes,
	ost_cv_posix_sys_atomic=no)
  if test $ost_cv_posix_sys_atomic = yes ; then
	AC_MSG_CHECKING([for atomic_t])
	AC_TRY_COMPILE([#include <sys/atomic.h>],
		[
		atomic_t at; at.counter = 1;
		atomic_dec_and_test(&at);
		atomic_sub(4, &at);
		atomic_inc(&at);
		atomic_add(3, &at);
		],
		[ost_cv_posix_atomic=yes
		AC_DEFINE(HAVE_WORKING_SYS_ATOMIC_H)],
		[ost_cv_posix_atomic=no])
	AC_MSG_RESULT($ost_cv_posix_atomic)
  elif test $ost_cv_posix_atomic = no ; then
	AC_MSG_CHECKING([for atomic operations])
	AC_TRY_LINK([#include <asm/atomic.h>],
		[
		atomic_t at; at.counter = 1;
		atomic_dec_and_test(&at);
		atomic_sub(4, &at);
		atomic_inc(&at);
		atomic_add(3, &at);
		],
		[ost_cv_posix_atomic=yes
		 AC_DEFINE(HAVE_ASM_ATOMIC_H)],
		[AC_TRY_LINK([#include <asm/atomic.h>],
			[atomic at; at = 1;],
			[ost_cv_posix_atomic=yes
			 AC_DEFINE(HAVE_ASM_ATOMIC_H) 
			AC_DEFINE(HAVE_ASM_ATOMIC_NOSTRUCT_BUTINT)]
		)]
	)
	AC_MSG_RESULT($ost_cv_posix_atomic)
  fi

  if test "$target" = NONE ; then
	targetdir=""
  else
	targetdir="$target"
  fi

  AC_CHECK_HEADERS(thread.h)
  if test "$prefix" = NONE ; then
	thrprefix="/usr/$targetdir/include"
	if test -d /usr/$targetdir/sys-include ; then
		thrprefix="$prefix/$targetdir/sys-include" ; fi
  else
	thrprefix="$prefix/$targetdir/include"
	if test -d "$prefix/$targetdir/sys-include" ; then
		thrprefix="$prefix/$targetdir/sys-include" ; fi
  fi

  if test ! -f $thrprefix/thread.h ; then
	thrprefix=/usr/include
  fi

  AC_SUBST(thrprefix)

  if test $ost_cv_posix_threads = yes ; then
    if test "$ost_cv_thread_library" = "none" ; then

	ost_cv_thread_flags=""
	for flags in -kthread -pthread -mthreads -pthreads -Kthread --threadsafe -mt ; do

		AC_MSG_CHECKING(whether ${CC-cc} accepts $flags)
		echo 'void f(){}' >conftest.c
		if test -z "`${CC-cc} $flags -c conftest.c 2>&1`"; then
			ost_cv_thread_flags=$flags
			AC_MSG_RESULT(yes)
		else
			AC_MSG_RESULT(no)
		fi
		rm -f conftest*
		if test ! -z "$ost_cv_thread_flags" ; then break ; fi
	done
#	if test "$ost_cv_prog_cc_pthread" = "no" ; then
#  	   AC_CACHE_CHECK(whether ${CC-cc} accepts -mthreads,
#		ost_cv_prog_cc_mthreads,
#		[echo 'void f(){}' >conftest.c
#		if test -z "`${CC-cc} -mthreads -c conftest.c 2>&1`"; then
#			ost_cv_prog_cc_mthreads=yes
# else
#			ost_cv_prog_cc_mthreads=no
#		fi
#		rm -f conftest*
#		])
#	fi
	ost_cv_thread_library=none
	AC_CHECK_LIB(c_r, pthread_self,
		ost_cv_thread_library=c_r,
		AC_CHECK_LIB(pthread, pthread_self,
			ost_cv_thread_library=pthread,
			AC_CHECK_LIB(pthread, pthread_kill,
				ost_cv_thread_library=pthread,
				AC_CHECK_LIB(pthreads, pthread_self,
					ost_cv_thread_library=pthreads,
					AC_CHECK_LIB(thread, pthread_self,
						ost_cv_thread_library=thread)))))

	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(gthreads, pthread_self,[
			AC_CHECK_LIB(malloc, malloc)
			ost_cv_thread_library=gthreads])
	fi
	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(cma, pthread_self,
			ost_cv_thread_library=cma)
	fi

	if test $ost_cv_thread_library = none ; then
		AC_CHECK_LIB(c, pthread_self,
			ost_cv_thread_library=c)
	fi

	if test $ost_cv_thread_library = none ; then
		AC_MSG_ERROR(no library for posix threads found!)
	fi
    else
#	ost_cv_prog_cc_pthread=no
#	ost_cv_prog_cc_mthreads=no
	ost_cv_thread_flags=""
    fi

	AC_CHECK_LIB(${ost_cv_thread_library}, nanosleep,
		AC_DEFINE(HAVE_PTHREAD_NANOSLEEP),[
		AC_CHECK_LIB(posix4, nanosleep,[
			AC_DEFINE(HAVE_PTHREAD_NANOSLEEP)
			THREAD_LIBS="$THREAD_LIBS -lposix4"
			],[
			AC_CHECK_LIB(rt, nanosleep,[
				AC_DEFINE(HAVE_PTHREAD_NANOSLEEP)
				THREAD_LIBS="$THREAD_LIBS -lrt"])
			])

		])

	if test ! -z "$ost_cv_thread_flags" ; then
		THREAD_LIBS="$THREAD_LIBS $ost_cv_thread_flags"
	else
		THREAD_LIBS="$THREAD_LIBS -l$ost_cv_thread_library"
	fi

	AC_MSG_CHECKING([if more special flags are required for pthreads])
        flag=no
        case "${host_cpu}-${host_os}" in
                *-aix* | *-freebsd*)     flag="-D_THREAD_SAFE";;
                *solaris* | alpha*-osf*) flag="-D_REENTRANT";;
        esac
        AC_MSG_RESULT(${flag})
        if test "x$flag" != xno; then
               THREAD_FLAGS="$flag"
        fi

	AC_SUBST(THREAD_FLAGS)
	AC_SUBST(THREAD_LIBS)
#	LIBS="$THREAD_LIBS $LIBS"
	if test "$ost_cv_thread_library" != "lthread" ; then
		AC_CHECK_HEADERS(pthread_np.h)
	fi
	AC_CHECK_HEADERS(semaphore.h)
	AC_CHECK_HEADERS(sched.h)
	AC_CHECK_HEADERS(sys/sched.h)
	AC_CACHE_CHECK([for recursive mutex type support], ost_cv_mutex_recursive,
	[
	ost_cv_mutex_recursive="none"

	AC_TRY_COMPILE(
		[#include <pthread.h>],
		[
		#ifndef PTHREAD_MUTEXTYPE_RECURSIVE
		#ifdef PTHREAD_MUTEX_RECURSIVE
		#define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE
		#endif
		#endif
		return (int)PTHREAD_MUTEXTYPE_RECURSIVE;
		],
		ost_cv_mutex_recursive="portable",
		[	
		AC_EGREP_HEADER(PTHREAD_MUTEXTYPE_RECURSIVE_NP,pthread.h,
			ost_cv_mutex_recursive=non-portable)
		AC_EGREP_HEADER(PTHREAD_MUTEX_RECURSIVE_INITIALIZER_NP, pthread.h,
			ost_cv_mutex_recursive=lthread)
		AC_EGREP_HEADER(PTHREAD_MUTEX_RECURSIVE_NP,pthread.h,
			ost_cv_mutex_recursive=linux) 
		AC_EGREP_HEADER(MUTEX_TYPE_COUNTING_FAST,pthread.h,
			ost_cv_mutex_recursive=counting)	
		])
		if test $ost_cv_mutex_recursive = "none" ; then
			if test $ost_cv_thread_library = "lthread" ; then
				ost_cv_mutex_recursive=linux
			fi
		fi
	rm -f conftest*
	])

	if test $ost_cv_mutex_recursive = "none" ; then
		AC_TRY_COMPILE(
			[#include <pthread.h>],
		 	[return MUTEX_TYPE_COUNTING_FAST;],
			ost_cv_mutex_recursive=counting)
	fi

	case $ost_cv_mutex_recursive in
	non-portable)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			PTHREAD_MUTEXTYPE_RECURSIVE_NP)
		;;
	linux)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			PTHREAD_MUTEX_RECURSIVE_NP)
		;;
	counting)
		AC_DEFINE(PTHREAD_MUTEXTYPE_RECURSIVE,
			MUTEX_TYPE_COUNTING_FAST)
		;;
	esac

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_mutexattr_settype,
		AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETTYPE),
		[
		AC_CHECK_LIB(${ost_cv_thread_library}, pthread_mutexattr_settype_np,
			AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP))
		AC_CHECK_LIB(${ost_cv_thread_library}, pthread_mutexattr_setkind_np,
			AC_DEFINE(HAVE_PTHREAD_MUTEXATTR_SETKIND_NP))
		]
	)

	ost_cv_thread_rwlock=false
	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_rwlock_init,[
		ost_cv_thread_rwlock=true
		AC_DEFINE(HAVE_PTHREAD_RWLOCK)])

	AC_CHECK_LIB(c, pread,[
		AC_DEFINE(HAVE_PREAD_PWRITE)],[
		AC_CHECK_LIB(${ost_cv_thread_library}, pread,[
			AC_DEFINE(HAVE_PREAD_PWRITE)],[
			AC_CHECK_LIB(c_r, pread,[AC_DEFINE(HAVE_PREAD_PWRITE)])
		])
	])

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_suspend,
		AC_DEFINE(HAVE_PTHREAD_SUSPEND))

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_attr_setstacksize,
		AC_DEFINE(HAVE_PTHREAD_ATTR_SETSTACKSIZE))

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_yield,
		AC_DEFINE(HAVE_PTHREAD_YIELD),[
		AC_CHECK_LIB(${ost_cv_thread_library}, sched_yield,
			AC_DEFINE(HAVE_PTHREAD_SCHED_YIELD))
		])

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_cancel,[
		AC_DEFINE(HAVE_PTHREAD_CANCEL)
	  	AC_CHECK_LIB(${ost_cv_thread_library},
			pthread_setcanceltype,
			AC_DEFINE(HAVE_PTHREAD_SETCANCELTYPE),
			AC_CHECK_LIB($ost_cv_thread_library, pthread_setcanel,
				AC_DEFINE(HAVE_PTHREAD_SETCANCEL)))
		],[
		AC_CHECK_LIB(${ost_cv_thread_library},
			pthread_setcanceltype,[
			AC_DEFINE(HAVE_PTHREAD_CANCEL)
			AC_DEFINE(HAVE_PTHREAD_SETCANCELTYPE)])

		])

	AC_CHECK_LIB(${ost_cv_thread_library}, pthread_delay_np,
		AC_DEFINE(HAVE_PTHREAD_DELAY_NP))

  fi

  UNAME=`uname`
  if test "$UNAME" = "AIX" ; then
	AC_CHECK_PROG(PTHREAD_CC, cc_r, cc_r, ${CC})
	CC=$PTHREAD_CC
	AC_DEFINE(COMMON_AIX_FIXES)
  fi
])

dnl ACCONFIG TEMPLATE
dnl #undef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #undef HAVE_PTHREAD_SUSPEND
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETTYPE
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP
dnl #undef HAVE_PTHREAD_MUTEXATTR_SETKIND_NP
dnl #undef HAVE_PTHREAD_ATTR_SETSTACKSIZE
dnl #undef HAVE_PTHREAD_DELAY_NP
dnl #undef HAVE_PTHREAD_SCHED_YIELD
dnl #undef HAVE_PTHREAD_YIELD
dnl #undef HAVE_PTHREAD_NANOSLEEP
dnl #undef HAVE_PTHREAD_CANCEL
dnl #undef HAVE_PTHREAD_SETCANCELTYPE
dnl #undef HAVE_PTHREAD_SETCANCEL
dnl #undef HAVE_PTHREAD_RWLOCK
dnl #undef HAVE_PREAD_PWRITE
dnl #undef HAVE_ASM_ATOMIC_H
dnl #undef HAVE_SYS_ATOMIC_H
dnl #undef HAVE_WORKING_SYS_ATOMIC_H
dnl #undef HAVE_ASM_ATOMIC_NOSTRUCT_BUTINT
dnl #undef HAVE_SEMAPHORE_H
dnl #undef COMMON_AIX_FIXES
dnl #undef HAVE_FEATURES_H
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl 
dnl #ifdef HAVE_THREAD_H
dnl #include "@thrprefix@/thread.h"
dnl #if defined(i386) && defined(__svr4__) && !defined(__sun)
dnl #define _THR_UNIXWARE
dnl #endif
dnl #if defined(__SVR4) && defined(__sun)
dnl #define _THR_SUNOS5
dnl #else
dnl #if defined(__SVR4__) && defined(__SUN__)
dnl #define _THR_SUNOS5
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #ifdef HAVE_WORKING_SYS_ATOMIC_H
dnl #include <sys/atomic.h>
dnl #define HAVE_ATOMIC
dnl #else
dnl #ifdef HAVE_ASM_ATOMIC_H
dnl #include <asm/atomic.h>
dnl #define HAVE_ATOMIC
dnl #endif
dnl #endif
dnl 
dnl #if defined(HAVE_PTHREAD_H) && ( defined(_THREAD_SAFE) || defined(_REENTRANT) )
dnl #ifndef _XOPEN_SOURCE
dnl #define _XOPEN_SOURCE 500
dnl #endif
dnl #ifndef _GNU_SOURCE
dnl #define _GNU_SOURCE 1
dnl #endif
dnl #ifdef HAVE_FEATURES_H
dnl #include <features.h>
dnl #endif
dnl #include <pthread.h>
dnl #ifdef HAVE_PTHREAD_NP_H
dnl #include <pthread_np.h>
dnl #endif
dnl #ifdef HAVE_SEMAPHORE_H
dnl #include <semaphore.h>
dnl #endif
dnl #ifdef _POSIX_PRIORITY_SCHEDULING
dnl #ifdef HAVE_SCHED_H
dnl #include <sched.h>
dnl #else
dnl #ifdef HAVE_SYS_SCHED_H
dnl #include <sys/sched.h>
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #define __PTHREAD_H__
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #ifdef  MUTEX_TYPE_COUNTING_FAST
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE MUTEX_TYPE_COUNTING_FAST
dnl #endif
dnl #endif
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #ifdef  PTHREAD_MUTEX_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE
dnl #endif
dnl #endif
dnl #ifndef HAVE_PTHREAD_MUTEXATTR_SETTYPE
dnl #if     HAVE_PTHREAD_MUTEXATTR_SETKIND_NP
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEX_RECURSIVE_NP
dnl #endif
dnl #define pthread_mutexattr_gettype(x, y) pthread_mutexattr_getkind_np(x, y)
dnl #define pthread_mutexattr_settype(x, y) pthread_mutexattr_setkind_np(x, y)
dnl #endif 
dnl #if     HAVE_PTHREAD_MUTEXATTR_SETTYPE_NP
dnl #ifndef PTHREAD_MUTEXTYPE_RECURSIVE
dnl #define PTHREAD_MUTEXTYPE_RECURSIVE PTHREAD_MUTEXTYPE_RECURSIVE_NP
dnl #endif
dnl #define pthread_mutexattr_settype(x, y) pthread_mutexattr_settype_np(x, y)
dnl #define pthread_mutexattr_gettype(x, y) pthread_mutexattr_gettype_np(x, y)
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_YIELD
dnl #ifdef HAVE_PTHREAD_SCHED_YIELD
dnl #define pthread_yield() sched_yield()
dnl #define HAVE_PTHREAD_YIELD
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_DELAY
dnl #ifdef HAVE_PTHREAD_DELAY_NP
dnl #define HAVE_PTHREAD_DELAY
dnl #define pthread_delay(x) pthread_delay_np(x)
dnl #endif
dnl #ifdef HAVE_PTHREAD_NANOSLEEP
dnl #ifndef HAVE_PTHREAD_DELAY
dnl #define HAVE_PTHREAD_DELAY
dnl #define pthread_delay(x) nanosleep(x, NULL)
dnl #endif
dnl #endif
dnl #endif
dnl 
dnl #ifdef HAVE_PTHREAD_ATTR_SETSTACK
dnl #ifndef PTHREAD_STACK_MIN
dnl #define PTHREAD_STACK_MIN 32768
dnl #endif
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_CANCEL
dnl #ifdef SIGCANCEL
dnl #define CCXX_SIG_THREAD_CANCEL SIGCANCEL
dnl #else
dnl #define CCXX_SIG_THREAD_CANCEL SIGQUIT
dnl #endif
dnl #define pthread_cancel(x) pthread_kill(x, CCXX_SIG_THREAD_CANCEL)
dnl #endif
dnl 
dnl #ifndef HAVE_PTHREAD_SETCANCELTYPE
dnl #ifdef HAVE_PTHREAD_SETCANCEL
dnl enum
dnl { PTHREAD_CANCEL_ASYNCHRONOUS = CANCEL_ON,
dnl   PTHREAD_CANCEL_DEFERRED = CANCEL_OFF};
dnl enum
dnl { PTHREAD_CANCEL_ENABLE = CANCEL_ON,
dnl   PTHREAD_CANCEL_DISABLE = CANCEL_OFF};
dnl #define pthread_setcancelstate(x, y) \
dnl 	(y == NULL) ? pthread_setcancel(x) : *y = pthread_setcancel
dnl #define pthread_setcanceltype(x, y) \
dnl 	(y == NULL) ? pthread_setasynccancel(x) | *y = pthread_setasynccancel(x)
dnl #else
dnl #define pthread_setcanceltype(x, y)
dnl #define pthread_setcancelstate(x, y)
dnl #endif
dnl #endif
dnl 
dnl #endif
dnl 
dnl END ACCONFIG

