#ifndef _console_h_
#define _console_h_

#include "sim.h"
#include <qwidget.h>
#include <qpixmap.h>

class QConsole : public QWidget
{
    Q_OBJECT
public:
    QConsole( LocalRobi& robi );
	virtual ~QConsole() {}
	id_t id() const { return robi.id; }
protected:
    void paintEvent( QPaintEvent* );
    void resizeEvent( QResizeEvent* );
	void keyPressEvent( QKeyEvent* e );
	void keyReleaseEvent( QKeyEvent* e );
private slots:
	void timer();
private:
	QPixmap screen_pm;
	QPixmap image_pm;
	QFont font;
	LocalRobi& robi;
	bool scale_image;
};

#endif /* _console_h_ */
