#ifndef CORE_H
#define CORE_H

#include "sim.h"

/* This is the set of messages the core can sent to the local robi clients */
struct Core2ClientMessages
{
	virtual void resumeRobi( id_t id ) = 0;

	virtual const Robi& startRobi( const char* executable, id_t id ) = 0;
	virtual void cleanup() = 0;

	virtual void deliverRADIOMessage( id_t id, const RADIOMessage& message ) = 0;
	virtual void reportCollision( id_t id, const Time& time ) = 0;
};

extern Core2ClientMessages* theClientsMessenger;

/* This namespace contains all the core functionality. It is not a
 * class, since there would only one be instance allowed anyway. */
namespace Core
{
	void setVWController( id_t id, const VWData& vwData );
	void synchronize( id_t id, const Time& time );
	void sendRADIOMessage( const RADIOMessage& message );
	void setKicker( id_t id, const double_pointxy& reflectionCoefficients,
					double speed );

	/** these are the methods to control the simulation, they are
	 * usually called from the GUI. */
	void setupSimulation( const char* fileName );
	void startSimulation();
	void pauseSimulation( bool pause );
	void stopSimulation();
	void changeRobiPosition( id_t i, const Position& newPos );
	void changeSimulationToRealTimeRatio( double r );
};

#endif
