#ifndef _inventor_h_
#define _inventor_h_

#include <vector>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/SbLinear.h>
#include <Inventor/nodes/SoSelection.h>

#include "world.h"

inline SbVec3f pointxy2SbVec3f( const double_pointxy& v, float z = 0. )
{
	return SbVec3f( v.x, v.y, z );
}

struct GuiUpdateRobiSelection
{ virtual void onUpdateSelection( bool selected ) = 0; };

/** each robi scene graph representation will be on instance of this
 * struct. It's element guiRef is used to update the selection of the
 * list view, in case the user changes the selection within the OpenGl
 * viewer. */
struct RobiNode : public SoSeparator
{
	GlobalRobi* robi;
	GuiUpdateRobiSelection* guiRef;
	RobiNode( GlobalRobi* r ) : robi(r), guiRef(0) {}
};

class SceneGraph : public OnWorldUpdateHandler
{
	World& world;
	vector<SbVec3f> vertices;
	vector<SbVec3f> normals;
	vector<int32_t> numvertices;
	vector<SoTransform*> robiTransforms;
	vector<SoTransform*> ballTransforms;

	SoSeparator* rootSG;
	SoSelection* selection;

	SoSeparator* setupWalls();
	SoSeparator* setupRobis();
	SoSeparator* setupBalls();

public:
	SceneGraph( World& world );
	virtual ~SceneGraph() {}

	SoSeparator* root();

	/** this is the callback implementation of the base class, it gets
	 * called if the underlying World has changed and it updates the
	 * transfomations of the robis, hence, updating their position. */
	void onUpdate();

	void clear();

	/** these functions are needed for the synchronization of the
	 * selection of the robis. */
	RobiNode* robiNode( size_t index );
	void setRobiNodeSelected( size_t index, bool selected );
};

extern SceneGraph theSceneGraph;

#endif /* _inventor_h_ */
