#include "eyebot.h"
#include "sim.h"

void Keyboard::keyDown( int k )
{
	CEnterCriticalSection l( lock );
	key = k;
}

void Keyboard::keyUp()
{
 	CEnterCriticalSection l( lock );
 	key = 0;
}

int Keyboard::check()
{
	CEnterCriticalSection l( lock );
	return key;
}

int Keyboard::wait( LocalRobi& robi )
{
	CEnterCriticalSection lock_watch( lock );

//BUG:
	/* this buisy loop implementation is basicaly the same than the
	 * radio message queue receive method, if anything is wrong with
	 * this it should be fixed in both places. */
	if( key == 0 )
	{
		if( robi.mtMode == NOTASK )
		{
			/* this is a buisy waiting loop, which is bad, of course
			 * but I am runnging out of time and this is a simpler
			 * solution than a "proper" one. */
			do
			{
				/* increment the virtualTime to the next
				 * synchronization time and synchronize to this time */
				robi.virtualTime.steps( robi.virtualTime.steps() + 1 );
				
				lock_watch.leave();
				theCoreMessenger->synchronize( robi.virtualTime );
				robi.lastSynchronization.steps( robi.virtualTime.steps() );
				lock_watch.enter();
			}
			/* until a message was received */
			while( key == 0 );

//BUG: it would be necessary to keep track of the timers properly, but
// as I said, I am short with time, and a problem only occurs for the case,
// that we have timers and no threads and blocking key board...
		}
		else
		{
			do
			{
				lock_watch.leave();
				robi.reschedule();
				lock_watch.enter();
			}
			while( key == 0 );
		}
	}

	int k = key;
	key = 0;
	return k;
}

namespace robios {

#define ENTER_ROBIOS_KEY \
	ENTER_ROBIOS; \

int KEYGetBuf( char* buf )
{
	ENTER_ROBIOS_KEY;
	*buf = robi.keyboard.wait( robi );
	return *buf;
}

int KEYGet()
{
	ENTER_ROBIOS_KEY;
	return robi.keyboard.wait( robi );
}

int KEYRead()
{
	ENTER_ROBIOS_KEY;
	if( robi.keyboard.check() )
		return robi.keyboard.wait( robi );
	else
		return 0;
}

int KEYWait( int key )
{
	ENTER_ROBIOS_KEY;

	int k;
	do
	{
		k = robi.keyboard.wait( robi );
	}
	while( key != k && key != ANYKEY );

	return k;
}

} /* namespace robios */
