#include "sim.h"
#include "settings.h"
#include <stdio.h>

#define gui

#ifdef gui
#include <qapplication.h>
#include "gui.h"
#endif

#include <iostream>

int main(int argc, char** argv)
{
	setlinebuf( stdout );

	try
	{
		readSettingsFile( "eyesim.ini" );

#ifdef gui
		QApplication a( argc, argv );
		AppController* ac = new AppController( argc == 2 ? argv[1] : 0 );
		a.setMainWidget( ac );
		ac->show();
		a.exec();
#else
		std::string simulationFile = argc < 2 ? "test.sim" : argv[1];
//			throw "usage: sim <simulation_file.sim>";

//		readSettingsFile( 0 );
		Core::setupSimulation( simulationFile.c_str() );
		Core::startSimulation();

#undef sleep
		sleep( (unsigned int)-1 );
#endif
	}
	catch( exception& e )
	{ cerr << e.what() << endl; }
	catch( const char* e )
	{ cerr << e << endl; }
	catch( ... )
	{ cerr << "unknown exception\n"; }

	return 0;
}
