#ifndef _thread_adapter_h_
#define _thread_adapter_h_

#include <cc++/thread.h>
#include <cc++/file.h>
#include "sim.h"
#include "core.h"

class Client2CoreMessagesThreadImplementation : public Client2CoreMessages
{
public:
	void setVWController( const VWData& vwData );
	void synchronize( const Time& time );
	void setKicker( const double_pointxy& reflectionCoefficients, double speed );
	void sendRADIOMessage( const RADIOMessage& message );
};

class Core2ClientMessagesThreadImplementation : public Core2ClientMessages
{
public:
	const Robi& startRobi( const char* executable, id_t id );
	void cleanup();
	void resumeRobi( id_t id );
	void deliverRADIOMessage( id_t id, const RADIOMessage& message );
	void reportCollision( id_t id, const Time& time );
};

class RobiThread : public ost::Thread
{
	ost::DSO dso;
	int (*main)();
	id_t id;

public:
	RobiThread( const char* executable, id_t id ) :
		Thread(), dso( const_cast<char*>(executable) ), id( id )
	{
		main = (int(*)())(dso["main"]);
	}

	void run();
	void Final();
	void Terminate() { terminate(); }
};

/* this is currently the way for the gui to get direct access to the
 * LocalRobi structures for displaying purposes. In distributed
 * implementation, it would be necessary, to find another way, since
 * there would be no global accessible location of this information. */
const vector<LocalRobi*>& theLocalRobis();

#endif /* _thread_adapter_h_ */
