#include <eyebot.h>
#include <stdio.h>


void camInit(void)
{
  int camera;		/* just used for checking camera status */

  camera = CAMInit(NORMAL);	/* CAMInit is an eyebot library func */

  if (camera == NOCAM)
    OSError("Camera not detected!\n Press any key to continue.\n", 4133, 0);
  else
    if (camera == INITERROR)
      OSError("Camera Initialisation Error!\n Press any key to continue.\n", 4133, 0);
}

/**
 * @brief Releases camera resources.
 */ 
void camRelease(void)
{
  if(CAMRelease()==-1)
    LCDPrintf("Warning: Camera Resources Not Released\n");
}

int initVW(VWHandle *vw_handle)
{
	 *vw_handle = VWInit(VW_DRIVE, 1);
        if (*vw_handle == 0) {
                LCDPrintf("VWInit() error\n");
                return false;
        }
        VWStartControl(*vw_handle, 7, 0.3, 7, 0.1); /*optimum drive control*/
        /* Vv: 7 (proportional component of the v-controller)
         * Tv: 0.3 (integrating component of the v-controller)
         * Vw: 7 (proportional component of the w-controller)
         * Tw: 0.1 (integrating component of the w-controller)
         */

	return true;
}

int releaseVW(VWHandle *vw_handle)
{
	if (VWStopControl(*vw_handle) == -1) 
	{
		LCDPrintf("error stopping VWControl...\n");
		return false;
	}

	if(VWRelease(*vw_handle)==-1)
	{
		LCDPrintf("error releasing VWHandle...\n");
		return false;
	}

	return true;
}

int main(void)
{
	colimage img;
	VWHandle vwhandler;
	double d=0.1;
	
	printf("cam init\n");
	camInit();	
	printf("cam init success\n");
	if(initVW(&vwhandler) == false) 
	{
		LCDPrintf("error in initVW()... \n");
		return false;
	}

	
	LCDPrintf("test\n");	
	LCDMenu("", "", "", "exit");
	
	do
	{
		CAMGetColFrame(&img, 0);
	
		LCDPutColorGraphic(&img);
		LCDPrintf("spinning around..\n");
		VWSetSpeed(1, 0, -0.2 * d);
		d+=0.1;
		
		
	}while (KEYRead()!=KEY4);
		
#ifdef DEBUG
	LCDPrintf("exiting...\n");
#endif
	if ( releaseVW(&vwhandler) == false)
	{
		LCDPrintf("error in releaseVW()... \n");
		return	false;
	}
	
	camRelease();
	return 0;
}
