#include <string.h>
#include "features.h"

RoBiOSFunctionFeatures DummyFeatures =
{ "UnknownRobiosFunction", 0.001, 1, 1 };

//	static const RoBiOSFunctionFeatures Features_##NAME =

static RoBiOSFunctionFeatures RoBiOSFunctionFeaturesTable[] = {

#define DEF_FF( NAME, CPS, TIMER, MT ) \
		{ #NAME, 1.0/(CPS), TIMER, MT },

	DEF_FF( PSDGet, 39065.78, 1, 1 )
	DEF_FF( PSDGetRaw, 42164.93, 1, 1 )
	DEF_FF( PSDCheck, 98834.50, 1, 1 )
	DEF_FF( AUBeep, 5.76, 1, 1 )
	DEF_FF( AUCheckSample, 100723.48, 1, 1 )
	DEF_FF( AUCaptureMic, 45473.98, 1, 1 )
	DEF_FF( AUCheckTone, 100619.32, 1, 1 )
	DEF_FF( AUCheckRecord, 100619.32, 1, 1 )
	DEF_FF( CAMGetFrame, 3.76, 1, 1 )
	DEF_FF( CAMGetColFrame, 3.76, 1, 1 )
	DEF_FF( CAMGetColFrame, 3.76, 1, 1 )
	DEF_FF( CAMSet, 83701.50, 1, 1 )
	DEF_FF( CAMGet, 58016.73, 1, 1 )
	DEF_FF( CAMMode, 3.76, 1, 1 )
	DEF_FF( IPLaplace, 27.95, 1, 1 )
	DEF_FF( IPSobel, 16.28, 1, 1 )
	DEF_FF( IPDither, 131.69, 1, 1 )
	DEF_FF( IPDiffer, 68.67, 1, 1 )
	DEF_FF( IPColor2Grey, 68.14, 1, 1 )
	DEF_FF( KEYRead, 2241.04, 1, 1 )
	DEF_FF( LCDPutGraphic, 49.60, 1, 1 )
	DEF_FF( LCDPutColorGraphic, 27.87, 1, 1 )
	DEF_FF( LCDPutImage, 123.44, 1, 1 )
	DEF_FF( LCDClear, 14.81, 1, 1 )
	DEF_FF( LCDPutChar, 1132.27, 1, 1 )
	DEF_FF( LCDSetChar, 4473.06, 1, 1 )
	DEF_FF( LCDPutString, 75.21, 1, 1 )
	DEF_FF( LCDSetString, 842.28, 1, 1 )
	DEF_FF( LCDPutHex, 139.30, 1, 1 )
	DEF_FF( LCDPutHex1, 554.19, 1, 1 )
	DEF_FF( LCDPutInt, 1033.13, 1, 1 )
	DEF_FF( LCDPutIntS, 185.82, 1, 1 )
	DEF_FF( LCDSetPixel, 10040.16, 1, 1 )
	DEF_FF( LCDInvertPixel, 10509.73, 1, 1 )
	DEF_FF( LCDGetPixel, 15591.40, 1, 1 )
	DEF_FF( LCDArea, 200, 1, 1 ) /* the cps value is an averageish value */
	DEF_FF( LCDLine, 500, 1, 1 ) /* the cps value is an averageish value */
	DEF_FF( LCDMode, 32770.61, 1, 1 )
	DEF_FF( LCDSetPos, 10826.61, 1, 1 )
	DEF_FF( LCDMenu, 341.58, 1, 1 )
	DEF_FF( LCDMenuI, 1357.92, 1, 1 )
	DEF_FF( LCDPrintf, 502.90, 1, 1 )
	DEF_FF( LCDSetPrintf, 459.39, 1, 1 )
	DEF_FF( LCDPutFloat, 349.94, 1, 1 )
	DEF_FF( LCDPutFloatS, 521.33, 1, 1 )
	DEF_FF( LCDGetPos, 65247.95, 1, 1 )
	DEF_FF( OSVersion, 106528.38, 1, 1 )
	DEF_FF( OSMachineType, 88452.10, 1, 1 )
	DEF_FF( OSMachineSpeed, 102766.84, 1, 1 )
	DEF_FF( OSMachineName, 100671.23, 1, 1 )
	DEF_FF( OSMachineID, 96894.60, 1, 1 )
	DEF_FF( OSEnable, 88691.89, 1, 1 )
	DEF_FF( OSGetVar, 45060.31, 1, 1 )
	DEF_FF( OSPutVar, 38177.34, 1, 1 )
	DEF_FF( OSMTStatus, 102604.88, 1, 1 )
	DEF_FF( OSSetTime, 58095.05, 1, 1 )
	DEF_FF( OSGetTime, 41848.84, 1, 1 )
	DEF_FF( OSShowTime, 35.37, 1, 1 )
	DEF_FF( OSGetCount, 102712.85, 1, 1 )
	DEF_FF( OSWait, 43505.67, 1, 1 )
	DEF_FF( OSSemV, 87737.63, 1, 1 )
	DEF_FF( OSSemP, 95278.43, 1, 1 )
	DEF_FF( RADIOGetIoctl, 48870.57, 1, 1 )
	DEF_FF( RADIOSetIoctl, 33046.31, 1, 1 )
	DEF_FF( RADIOCheck, 68165.69, 1, 1 )
	DEF_FF( OSInitRS232, 18836.58, 1, 1 )
	DEF_FF( OSCheckInRS232, 54120.29, 1, 1 )
	DEF_FF( OSCheckOutRS232, 59304.70, 1, 1 )
	DEF_FF( OSFlushInRS232, 46955.42, 1, 1 )
	DEF_FF( OSFlushOutRS232, 55692.24, 1, 1 )
	DEF_FF( VWRelease, 5.00/2, 1, 1 )
	DEF_FF( VWInit, 5.00/2, 1, 1 )
	DEF_FF( VWSetSpeed, 823.91, 1, 1 )
	DEF_FF( VWGetSpeed, 3194.84, 1, 1 )
	DEF_FF( VWSetPosition, 4901.97, 1, 1 )
	DEF_FF( VWGetPosition, 21155.73, 1, 1 )
	DEF_FF( VWDriveStraight, 842.14, 1, 1 )
	DEF_FF( VWDriveTurn, 773.33, 1, 1 )
	DEF_FF( VWDriveCurve, 616.21, 1, 1 )
	DEF_FF( VWDriveRemain, 8537.00, 1, 1 )
	DEF_FF( VWDriveDone, 28748.27, 1, 1 )
	DEF_FF( VWStalled, 2129.82, 1, 1 )
	/* the value used is the value of a SetServo command divided by 2
	 * since two servos have to be set. */
	DEF_FF( SIM_CAMSetPanTiltAnlge, 32886.04/2., 1, 1 )
	DEF_FF( SIM_SetKicker, 32886.04, 1, 1 )

	{ 0, 0, 0, 0 } /* terminates the list */
};

const RoBiOSFunctionFeatures* findFunctionFeatures( const char* functionName )
{
	RoBiOSFunctionFeatures* i = &RoBiOSFunctionFeaturesTable[0];
	while( i->name != 0 && strcmp( i->name, functionName ) )
		++i;
	return i->name ? i : &DummyFeatures;
}
