#ifndef _parser_h_
#define _parser_h_

#include <map>
#include <string>

inline bool starts_with( string& s, const string& t )
{
	if( t == s.substr(0, t.size()) )
	{
		s.erase(0, t.size());
		return true;
	}
	else
		return false;
}

typedef std::map<std::string, std::string> Configuration;

/** this operator is just for convenience, it simply adds the passed
 * string to the map. */
inline Configuration& operator<<( Configuration& c, const std::string& s )
{ c[s]; return c; }

void parseConfigurationFile( const char* fileName, Configuration& config,
							 const std::string& commentChars = "#;" );

#endif /* _parser_h_ */
