#include "eyebot.h"
#include "sim.h"
#include <sstream>

namespace robios {

#define ENTER_ROBIOS_RS232 \
	if( face > SERIAL3 ) \
		return 10; \
	ENTER_ROBIOS; \

int OSInitRS232(int baudrate, int handshake, int face)
{
	ENTER_ROBIOS_RS232;
	std::ostringstream oss;
	oss << "serial_out_robi-" << robi.id << ".txt";
	robi.rs232out.open( oss.str().c_str() );
	return 0;
}

int OSCheckInRS232(int face)
{
//BUG: return code if face is wrong
	ENTER_ROBIOS_RS232;
	return 0xffffff02;
}

int OSCheckOutRS232(int face)
{
//BUG: return code if face is wrong
	ENTER_ROBIOS_RS232;
	return 0;
}

int OSFlushInRS232(int face)
{
	ENTER_ROBIOS_RS232;
	return 0;
}

int OSFlushOutRS232(int face)
{
	ENTER_ROBIOS_RS232;
	return 0;
}

int OSRecvRS232(char *chara, int face)
{
	ENTER_ROBIOS_RS232;
	*chara = 0;
	return 0;
}

int OSSendCharRS232(const char ch, const int face)
{
	ENTER_ROBIOS_RS232;
	robi.rs232out << ch << std::flush;
	return 0;
}

int OSSendRS232(const char *ch, const int face)
{
	ENTER_ROBIOS_RS232;
	robi.rs232out << *ch << std::flush;
	return 0;
}

} /* namespace robios */
