#include "eyebot.h"
#include "sim.h"
#include "world.h"
#include <stdio.h>

//  Simulator functions not implemented on the real eyebot
//  hardware
//
//  Daniel Venkitachalam  2002

extern World theWorld;

namespace robios {

#define ENTER_ROBIOS_SIM \
	ENTER_ROBIOS;  \

#define ROBIOS_STUB \
		ENTER_ROBIOS;\
		dbg_msg( "robi " << robi.id << " called unimplemented RoBiOS function '" \
				<< __func__ << "'" << endl ); \
		return 0;

	void SIMGetActualPos(double *x, double *y)
	{
		ENTER_ROBIOS_SIM
		//  Get my ID
		id_t id = robi.id;
		GlobalRobi& globalRobi = theWorld.robis[id];

		*x = globalRobi.pos.x;
		*y = globalRobi.pos.y;
	}

	void SIMGetActualPhi(double *phi)
	{
		ENTER_ROBIOS_SIM
		id_t id = robi.id;
		GlobalRobi& globalRobi = theWorld.robis[id];

		*phi = globalRobi.pos.phi;
	}

	void SIMGetActualBallPos(int id, double *x, double *y)
	{
		ENTER_ROBIOS_SIM
		Ball& ball = theWorld.balls[id];

		*x = ball.pos.x;
		*y = ball.pos.y;
	}

	//  Need to implement this more carefully
//	void SIMSetBallPos(int id, double x, double y)
//	{
//		ENTER_ROBIOS_SIM
//		Ball& ball = theWorld.balls[id];
//
//		ball.pos.x = x;
//		ball.pos.y = y;
//	}

	//  Not the nicest way to do this, but effective
	void SIMExit(int code)
	{
		throw "SIMExit called()\n";
		// exit(code);
	}

}
