#ifndef eyebot_h
#define eyebot_h

namespace robios {

#include "types.h"


int function( int n );

/* VW  ********************************************************************* */

extern VWHandle VWInit(DeviceSemantics, int);
extern int VWRelease(VWHandle);
extern int VWSetSpeed(VWHandle, meterPerSec, radPerSec);
extern int VWGetSpeed(VWHandle, SpeedType*);
extern int VWSetPosition(VWHandle, meter, meter, radians);
extern int VWGetPosition(VWHandle, PositionType*);
extern int VWStartControl(VWHandle, float, float, float, float);
extern int VWStopControl(VWHandle);
extern int VWDriveStraight(VWHandle, meter, meterPerSec);
extern int VWDriveTurn(VWHandle handle, radians, radPerSec);
extern int VWDriveCurve(VWHandle, meter, radians, meterPerSec);
extern float VWDriveRemain(VWHandle);
extern int VWDriveDone(VWHandle);
extern int VWDriveWait(VWHandle);
extern int VWStalled(VWHandle);


/* PSD  ******************************************************************** */

extern PSDHandle PSDInit(DeviceSemantics);
extern int PSDRelease();
extern int PSDStart(PSDHandle, BOOL);
extern int PSDStop();
extern BOOL PSDCheck();
extern int PSDGet(PSDHandle);
extern int PSDGetRaw(PSDHandle);


/* LCD  ******************************************************************** */

#include "lcd.h"

extern int LCDPrintf( const char* fmt, ... );
extern int LCDSetPrintf( int row, int col, const char* fmt, ... );
extern int LCDClear( void );
extern int LCDPutChar( char c );
extern int LCDSetChar( int row ,int col, char c );
extern int LCDPutString( char* s );
extern int LCDSetString( int row, int col, char* s );
extern int LCDMode( int mode );
extern int LCDGetPos( int* row, int* col );
extern int LCDSetPos( int row, int col );
extern int LCDPutColorGraphic( colimage *buf );
extern int LCDPutGraphic( image* buf );
extern int LCDPutImage( BYTE* buf );
extern int LCDMenu( char* s1, char* s2, char* s3, char* s4 );
extern int LCDMenuI( int pos, char* s );
extern int LCDSetPixel( int row, int col, BOOL b );
extern int LCDInvertPixel( int row, int col );
extern int LCDGetPixel( int row, int col );
extern int LCDLine(int, int, int, int, int);
extern int LCDArea(int, int, int, int, int );


/* KEY ********************************************************************* */

#include "keys.h"

extern int KEYGetBuf(char* buf);
extern int KEYGet();
extern int KEYRead();
extern int KEYWait(int key);

/* OS/Multi-Threading ****************************************************** */

#define IDLE_STACKSIZE      128         /* stack sizes */
#define DEFAULT_STACKSIZE   4096
#define SMALL_STACKSIZE     2048

#define MAX_PRI 8               /* MAX and MIN pri allowed for user programs */
#define MIN_PRI 1
#define IDLE_PRI 0              /* this pri is reserved for the system  */

extern int OSMTInit(BYTE mode);
extern int OSMTStatus();
extern struct tcb* OSSpawn(char* name, void (*code)(), int stksiz, int pri, int uid);
extern int OSReady(struct tcb* thread);
extern int OSSuspend(struct tcb* thread);
extern int OSReschedule();
extern int OSYield();
extern int OSRun(struct tcb* thread);
extern int OSGetUID(struct tcb* thread);
extern int OSKill(struct tcb* thread);
extern int OSExit(int code);
extern int OSPanic(char* msg);
extern int OSSleep(int timeout);
extern int OSForbid();
extern int OSPermit();

struct sem { void* impl; sem() : impl(0) {} };
extern int OSSemInit(struct sem* s, int val);
extern int OSSemP(struct sem* s);
extern int OSSemV(struct sem* s);

extern int OSSetTime(int h, int m, int s);
extern int OSGetTime(int* h, int* m, int* s, int* ticks);
extern int OSShowTime();
extern int OSGetCount();
extern int OSWait(int n);

extern TimerHandle OSAttachTimer(int scale, TimerFnc function);
extern int OSDetachTimer(TimerHandle handle);

extern int OSError(char* message, int number, BOOL dead );
extern int OSMachineType();
BYTE OSMachineID();
const char* OSMachineName();
extern int OSMachineSpeed();
extern const char* OSVersion();


/* RADIO ******************************************************************** */

extern int RADIOInit();
extern int RADIOTerm();
extern int RADIOCheck();
extern int RADIORecv(BYTE* id, int* bytesReceived, BYTE* buffer);
extern int RADIOSend(BYTE id, int byteCount, BYTE* buffer);
extern int RADIOSetIoctl(RadioIOParameters radioParams);
extern int RADIOGetIoctl(RadioIOParameters* radioParams);
extern int RADIOGetStatus(RadioStatus *s);


/* CAM ********************************************************************** */

#include "cam.h"

extern int CAMInit(int zoom);
extern int CAMRelease();
extern int CAMGetFrame(image* buf);
extern int CAMGetColFrame(colimage * buf, int convert);
extern int CAMSet(int bright, int para1, int para2 );
extern int CAMGet(int *bright, int *offsetORhue, int *contrastORsaturation);
extern int CAMMode(int mode);

/* this function is not part of the RoBiOS. I had to introduce it here, since
 * the servos are not simulated but one needs the ability to adjust the pan
 * and tilt angle of the camera. */
extern int SIM_CAMSetPanTiltAnlge( radians pan, radians tilt );
extern int SIM_SetKicker( float parallelRef, float perpendicularRef, float speed );

/* IP *********************************************************************** */

extern int IPLaplace (image *, image *);
extern int IPSobel (image *, image *);
extern int IPDither (image *, image *);
extern int IPDiffer (image *, image *, image *);
extern int IPColor2Grey (colimage *, image *);


/* RS232 ******************************************************************** */

#include "rs232.h"

extern int OSCheckInRS232(int face);
extern int OSCheckOutRS232(int face);
extern int OSFlushInRS232(int face);
extern int OSFlushOutRS232(int face);
extern int OSInitRS232(int baudrate, int handshake, int face);
extern int OSRecvRS232(char *chara, int face);
extern int OSSendCharRS232(const char ch, const int face);
extern int OSSendRS232(const char *ch, const int face);


/* ************************************************************************** */
/* the following functions are not implemented, there is merely a stub
 * provided, that just prints a warning onto the console of the
 * simulator. */
/* ************************************************************************** */

extern int OSEnable();
extern int OSDisable();
extern int OSGetVar(int num);
extern int OSPutVar(int num, int val);

extern int OSDownload(char *name,int *bytes,int baud,int handshake,int face);

extern int AUPlaySample(char* sample);
extern int AUCheckSample();
extern int AURecordSample(BYTE* buf, long len, long freq);
extern int AUCheckRecord();
extern int AUTone(int , int );
extern int AUBeep();
extern int AUCaptureMic();
extern int AUCheckTone();

extern ServoHandle SERVOInit(DeviceSemantics semantics);
extern int SERVORelease(ServoHandle handle);
extern int SERVOSet(ServoHandle handle,int angle);

extern MotorHandle MOTORInit(DeviceSemantics semantics);
extern int MOTORRelease(MotorHandle handle);
extern int MOTORDrive(MotorHandle handle,int speed);

extern QuadHandle QuadInit(DeviceSemantics semantics);
extern int QuadRelease(QuadHandle handle);
extern int QuadReset(QuadHandle handle);
extern int QuadRead(QuadHandle handle);
extern DeviceSemantics QUADGetMotor(DeviceSemantics semantics);
extern float QUADODORead(QuadHandle handle);
extern int QUADODOReset(QuadHandle handle);

extern BumpHandle BUMPInit(DeviceSemantics);
extern int BUMPRelease(BumpHandle);
extern int BUMPCheck(BumpHandle , int *);

extern IRHandle IRInit(DeviceSemantics);
extern int IRRelease(IRHandle);
extern int IRRead(IRHandle);

extern BYTE OSReadInLatch(int latchnr);
extern BYTE OSWriteOutLatch(int latchnr, BYTE mask, BYTE value);
extern BYTE OSReadOutLatch(int latchnr);
extern BYTE OSReadParData();
extern void OSWriteParData(BYTE value);
extern BYTE OSReadParSR();
extern void OSWriteParCTRL(BYTE value);
extern BYTE OSReadParCTRL();

extern int OSGetAD(int);
extern int OSOffAD(int mode);

extern int COMPASSCalibrate(int mode);
extern int COMPASSCheck(void);
extern int COMPASSGet(void);
extern int COMPASSInit(DeviceSemantics semantics);
extern int COMPASSRelease(void);
extern int COMPASSStart(BOOL cycle);
extern int COMPASSStop(void);

//  Sim functions
void SIMGetActualPos(double *x, double *y);
void SIMGetActualBallPos(int id, double *x, double *y);
void SIMSetBallPos(int id, double x, double y);
void SIMExit(int code);

};

using namespace robios;

#include "hdt_sem.h"

#endif
