#ifndef _TYPDEFS_H_
#define _TYPDEFS_H_

#include "types.h"

typedef int (*VWInitPointer) (int, int);
typedef int (*VWReleasePointer) (int);
typedef int (*VWSetSpeedPointer) (int, float, float);
typedef int (*VWGetSpeedPointer) (int, SpeedType*);
typedef int (*VWSetPositionPointer) (int, meter, meter, radians);
typedef int (*VWGetPositionPointer) (int, PositionType*);
typedef int (*VWStartControlPointer) (int, float, float, float, float);
typedef int (*VWStopControlPointer) (VWHandle);
typedef int (*VWDriveStraightPointer) (VWHandle, meter, meterPerSec);
typedef int (*VWDriveTurnPointer) (VWHandle, radians, radPerSec);
typedef int (*VWDriveCurvePointer) (VWHandle, meter, radians, meterPerSec);
typedef float (*VWDriveRemainPointer) (VWHandle);
typedef int (*VWDriveDonePointer) (VWHandle);
typedef int (*VWDriveWaitPointer) (VWHandle);
typedef int (*VWStalledPointer) (VWHandle);

/* PSD ***************************************************************************************************/

typedef PSDHandle (*PSDInitPointer) ( int );
typedef int (*PSDReleasePointer) ();
typedef int (*PSDStartPointer) (PSDHandle, BOOL);
typedef int (*PSDStopPointer) ();
typedef BOOL (*PSDCheckPointer) ();
typedef int (*PSDGetPointer) (PSDHandle);
typedef int (*PSDGetRawPointer) (PSDHandle);


/* LCD ***************************************************************************************************/

typedef int (*LCDPrintfPointer) (const char*, ...);
typedef int (*LCDSetPrintfPointer) (int, int, const char*, ...);
typedef int (*LCDClearPointer) ();
typedef int (*LCDPutCharPointer) (char);
typedef int (*LCDSetCharPointer) (int, int, char);
typedef int (*LCDPutStringPointer) (char*);
typedef int (*LCDSetStringPointer) (int, int, char*);
typedef int (*LCDModePointer) (int);
typedef int (*LCDGetPosPointer) (int*, int*);
typedef int (*LCDSetPosPointer) (int, int);
typedef int (*LCDPutColorGraphicPointer) (colimage*);
typedef int (*LCDPutGraphicPointer) (image*);
typedef int (*LCDPutImagePointer) (BYTE*);
typedef int (*LCDMenuPointer) (char*, char*, char*, char*);
typedef int (*LCDMenuIPointer) (int, char*);
typedef int (*LCDSetPixelPointer) (int, int, BOOL);
typedef int (*LCDInvertPixelPointer) (int, int);
typedef int (*LCDGetPixelPointer) (int, int);
typedef int (*LCDLinePointer) (int, int, int, int, int);
typedef int (*LCDAreaPointer) (int, int, int, int, int);

/* KEY ***************************************************************************************************/

typedef int (*KEYGetBufferPointer) (char*);
typedef int (*KEYGetPointer) ();
typedef int (*KEYReadPointer) ();
typedef int (*KEYWaitPointer) (int);

/* OS/Multi-Threading *************************************************************************************/

typedef int (*OSMTInitPointer) (BYTE);
typedef int (*OSMTStatusPointer) ();
typedef struct tcb* (*OSSpawnPointer) (char*, void (*code)(), int, int, int);
typedef int (*OSReadyPointer) (struct tcb*);
typedef int (*OSSuspendPointer) (struct tcb*);
typedef int (*OSReschedulePointer) ();
typedef int (*OSYieldPointer) ();
typedef int (*OSRunPointer) (struct tcb*);
typedef int (*OSGetUIDPointer) (struct tcb*);
typedef int (*OSKillPointer) (struct tcb*);
typedef int (*OSExitPointer) (int);
typedef int (*OSPanicPointer) (char*);
typedef int (*OSSleepPointer) (int);
typedef int (*OSForbidPointer) ();
typedef int (*OSPermitPointer) ();
typedef int (*OSSEMInitPointer) (struct sem*, int);
typedef int (*OSSemPPointer) (struct sem*);
typedef int (*OSSemVPointer) (struct sem*);
typedef int (*OSSetTimePointer) (int, int, int);
typedef int (*OSGetTimePointer) (int*, int*, int*, int*);
typedef int (*OSShowTimePointer) ();
typedef int (*OSGetCountPointer) ();
typedef int (*OSWaitPointer) (int);
typedef TimerHandle (*OSAttachTimerPointer) (int, TimerFnc);
typedef int (*OSDetachTimerPointer) (TimerHandle);
typedef int (*OSErrorPointer) (char*, int, BOOL);
typedef int (*OSMachineTypePointer) ();
typedef BYTE (*OSMachineIDPointer) ();
typedef const char* (*OSMachineNamePointer) ();
typedef int (*OSMachineSpeedPointer) ();
typedef const char* (*OSVersionPointer) ();

/* RADIO ***************************************************************************************************/

typedef int (*RADIOInitPointer) ();
typedef int (*RADIOTermPointer) ();
typedef int (*RADIOCheckPointer) ();
typedef int (*RADIORecvPointer) (BYTE*, int*, BYTE*);
typedef int (*RADIOSendPointer) (BYTE, int, BYTE*);
typedef int (*RADIOSetIoct1Pointer) (RadioIOParameters);
typedef int (*RADIOGetIoct1Pointer) (RadioIOParameters*);
typedef int (*RADIOGetStatusPointer) (RadioStatus*);

/* CAM ***************************************************************************************************/

typedef int (*CAMInitPointer) (int);
typedef int (*CAMReleasePointer) ();
typedef int (*CAMGetFramePointer) (image*);
typedef int (*CAMGetColFramePointer) (colimage*, int);
typedef int (*CAMSetPointer) (int, int, int);
typedef int (*CAMGetPointer) (int*, int*, int*);
typedef int (*CAMModePointer) (int);

/* IP ***************************************************************************************************/

typedef int (*IPLaplacePointer) (image*, image*);
typedef int (*IPSobelPointer) (image*, image*);
typedef int (*IPDitherPointer) (image*, image*);
typedef int (*IPDifferPointer) (image*, image*);
typedef int (*IPColor2GreyPointer) (colimage*, image*);

/* RS232 ***************************************************************************************************/

typedef int (*OSCheckInRS232Pointer) (int);
typedef int (*OSCheckOutRS232Pointer) (int);
typedef int (*OSFlushInRS232Pointer) (int);
typedef int (*OSFlushOutRS232Pointer) (int);
typedef int (*OSInitRS232Pointer) (int, int, int);
typedef int (*OSRecvRS232Pointer) (char*, int);
typedef int (*OSSendCharRS232Pointer) (const char, const int);
typedef int (*OSSendRS232Pointer) (const char*, const int);

/**********************************************************************************************************/

typedef int (*OSEnablePointer) ();
typedef int (*OSDisablePointer) ();
typedef int (*OSGetVarPointer) (int);
typedef int (*OSPutVarPointer) (int, int);
typedef int (*OSDownloadPointer) (char*, int*, int, int, int);
typedef int (*AUPlaySamplePointer) (char*);
typedef int (*AUCheckSamplePointer) ();
typedef int (*AURecordSamplePointer) (BYTE*, long, long);
typedef int (*AUCheckRecordPointer) ();
typedef int (*AUTonePointer) (int, int);
typedef int (*AUBeepPointer) ();
typedef int (*AUCaptureMicPointer) ();
typedef int (*AUCheckTonePointer) ();
typedef ServoHandle (*SERVOInitPointer) (DeviceSemantics);
typedef int (*SERVOReleasePointer) (ServoHandle);
typedef int (*SERVOSetPointer) (ServoHandle, int);
typedef MotorHandle (*MOTORInitPointer) (DeviceSemantics);
typedef int (*MOTORReleasePointer) (MotorHandle);
typedef int (*MOTORDrivePointer) (MotorHandle, int);
typedef QuadHandle (*QUADInitPointer) (DeviceSemantics);
typedef int (*QUADReleasePointer) (QuadHandle);
typedef int (*QUADResetPointer) (QuadHandle);
typedef int (*QUADReadPointer) (QuadHandle);
typedef DeviceSemantics (*QUADGetMotorPointer) (DeviceSemantics);
typedef float (*QUADODOReadPointer) (QuadHandle);
typedef int (*QUADODOResetPointer) (QuadHandle);
typedef BumpHandle (*BUMPInitPointer) (DeviceSemantics);
typedef int (*BUMPReleasePointer) (BumpHandle);
typedef int (*BUMPCheckPointer) (BumpHandle, int*);
typedef IRHandle (*IRInitPointer) (DeviceSemantics);
typedef int (*IRReleasePointer) (IRHandle);
typedef int (*IRReadPointer) (IRHandle);
typedef BYTE (*OSReadInLatchPointer) (int);
typedef BYTE (*OSWriteOutLatchPointer) (int, BYTE, BYTE);
typedef BYTE (*OSReadOutLatchPointer) (int);
typedef BYTE (*OSReadParDataPointer) ();
typedef void (*OSWriteParDataPointer) (BYTE);
typedef BYTE (*OSReadParSRPointer) ();
typedef void (*OSWriteParCTRLPointer) (BYTE);
typedef BYTE (*OSReadParCTRLPointer) ();
typedef int (*OSGetADPointer) (int);
typedef int (*OSOffADPointer) (int);
typedef int (*COMPASSCalibratePointer) (int);
typedef int (*COMPASSCheckPointer) ();
typedef int (*COMPASSGetPointer) ();
typedef int (*COMPASSInitPointer) (DeviceSemantics);
typedef int (*COMPASSReleasePointer) ();
typedef int (*COMPASSStartPointer) (BOOL);
typedef int (*COMPASSStopPointer) ();
typedef int (*SIMGetActualPosPointer) (double*, double*);
typedef int (*SIMGetActualPhiPointer) (double*);
typedef int (*SIMGetActualBallPosPointer) (int, double*, double*);
typedef int (*SIMSetBallPosPointer) (int, double, double);
typedef int (*SIMExitPointer) (int);
typedef int (*SIM_CAMSetPanTiltAnglePointer) (radians, radians);
typedef int (*SIM_SetKickerPointer) (float, float, float);

#endif










































