/*
| ---------------------------------------------------------------------
| Filename: hdtomni.c
| Author:   Thomas Braunl   (braunl@ee.uwa.edu.au)
|
| Description: 
| -------
| HDT data for Omni-Directional Robot, UWA, April 1999
| ---------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. */
#define NAME "Omni"           /* Unique name max. 10 chars */
#define ID   10               /* Unique platform id (int)  */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* PSD-sensor */
short dist0[128] = {60,60,60,60,60,60,60,60,60,60,            /*   1- 20 */
                    60,60,60,60,60,60,60,60,60,60,            /*  21- 40 */
                    60,60,80,100,109,110,112,114,117,119,     /*  41- 60 */
                    122,125,129,133,137,141,146,150,154,158,  /*  61- 80 */
                    162,166,170,175,180,185,190,196,202,208,  /*  81-100 */
                    214,220,226,232,238,244,250,256,262,268,  /* 101-120 */
                    274,280,286,292,297,303,309,315,321,328,  /* 121-140 */
                    335,342,350,359,367,374,383,392,402,412,  /* 141-160 */
                    422,433,446,459,473,495,518,540,562,586,  /* 161-180 */
                    611,641,671,701,752,800,852,910,953,999,  /* 181-200 */
                    999,999,999,999,999,999,999,999,999,999,  /* 201-220 */
                    999,999,999,999,999,999,999,999,999,999,  /* 221-240 */
                    999,999,999,999,999,999,999,999};         /* 241-256 */


BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
motor_type motor0 = {2,  1, TIMER1, 8191, (void*)OutBase, 3, 2, (BYTE*)&motconv0};
motor_type motor1 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
motor_type motor2 = {2,  6, TIMER1, 8191, (void*)OutBase, 5, 7, (BYTE*)&motconv0};
motor_type motor3 = {2,  7, TIMER1, 8191, (void*)OutBase, 6, 7, (BYTE*)&motconv0};

quad_type decoder0 = {0, 2, 3, MOTOR_FL, 3235, 2.0};
quad_type decoder1 = {0, 5, 4, MOTOR_FR, 3235, 2.0};
quad_type decoder2 = {0, 8, 9, MOTOR_BL, 3235, 2.0};
quad_type decoder3 = {0,11,10, MOTOR_BR, 3235, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_FL, QUAD_FR, 0.084}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo11 = {2, 12, TIMER2, 20000, 1500, 2150}; /* camera */
servo_type servo12 = {2, 13, TIMER2, 20000, 1550, 1750}; /* kicker */


/* PSD-infrared */
psd_type   psd0   = {0, 14, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd2   = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER57600,RTSCTS,SERIAL1,0,0,
                       AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */ /* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */    waitstate_type waitstates = {0,3,1,2,1,2};


HDT_entry_type HDT[] =
{
    MOTOR,MOTOR_FR,"FRT-R",(void *)&motor0,
    MOTOR,MOTOR_FL,"FRT-L",(void *)&motor1,
    MOTOR,MOTOR_BR,"BCK-R",(void *)&motor2,
    MOTOR,MOTOR_BL,"BCK-L",(void *)&motor3,
/*    QUAD, QUAD_FR,"FRT-R",(void *)&decoder1,
    QUAD, QUAD_FL,"FRT-L",(void *)&decoder0,
    QUAD, QUAD_BR,"BCK-R",(void *)&decoder3,
    QUAD, QUAD_BL,"BCK-L",(void *)&decoder2,
    VW,VW,"Drive",(void *)&drive,
*/
    /* BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0, */
    /* IR, IR_LF,"LF",(void *)&ir0,             */

    /* SERVO,SERVO11,"S11-C",(void *)&servo11,
    SERVO,SERVO12,"S12-K",(void *)&servo12, */

    PSD,PSD_LEFT,      "P0-L", (void *)&psd0,
    PSD,PSD_FRONT,     "P1-F", (void *)&psd1,
    PSD,PSD_RIGHT,     "P2-R", (void *)&psd2,

    WAIT,WAIT,"WAIT",(void *)&waitstates,
    INFO,INFO,"INFO",(void *)&roboinfo,

    END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0
};

