/* fileName: simple.c
 * purpose: print acc data from Jack-II biped to LCD
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 */

#include "librobi/librobi.h"
#include "libimpro/improc.h"
#include "librobi/protos.h"

#include "keys.h"
#include "lcd.h"
#include "hdt.h"
#include "hdt_sem.h"
#include "rs232.h"

#include <stdio.h>
#include <stdlib.h>

/* from assembly subroutine */
int accinit();
int accreadX();
int accreadY();


void main( void )
	{
	char done=0;
	int key=0;
	int delay=50;

	setvbuf( stdout, NULL, _IONBF, 0 );	
	setvbuf( stdin, NULL, _IONBF, 0 );	
	LCDMode( SCROLLING | NOCURSOR );
	
	accinit();

	LCDClear();
	LCDMenu( "dly", "", "", "quit" );
	LCDSetPos( 0, 0 );
	printf( "accX:" );
	LCDSetPos( 1, 0 );
	printf( "accY:" );

	while (!done)
		{
		LCDSetPos( 0, 6 );
		printf( "%d\n", accreadX() );
		LCDSetPos( 1, 6 );
		printf( "%d\n", accreadY() );

		key = KEYGet();
		
		switch (key)
			{
			case KEY1:
				delay += 20;
				delay %= 100;
				break;
			case KEY4:
				done = 1;
				break;
			default:
				break;
			}

		OSWait( delay );
		}
	}
