/* fileName: biped.h
 * purpose: Definitions for biped
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 * version: v0.00a
 * bugs:
 * notes: 
 * abbreviations:
	* c - constant
	* FB - front/back
	* LR - left/right
	* acc - acceleration
 */

/* Constants */

/* Servos */
#define cNumServos                     9

#define torso                          0
#define lHipT                          1
#define rHipT                          2
#define lHipB                          3
#define rHipB                          4
#define lKnee                          5
#define rKnee                          6
#define lAnkle                         7
#define rAnkle                         8
/* arms or ankles access the same point */
#define lArm                           7
#define rArm                           8

/* Foot Opto-Electric Switches */
#define cFootPort                      0
#define cFootLBMask                    0x01
#define cFootLFMask                    0x02
#define cFootRBMask                    0x04
#define cFootRFMask                    0x08


/* LCD Screen */
#define cLCDWidth                      128
#define cLCDHeight                     64

/* Methods */

/** @param acc: set to true if you need to access the acc sensors
  * @param servo: set to true if you need to drive the servos */
void bipedInit( bool acc, bool servo );

/** @param newPosture: pointer to array of joint angles to be accessed
  * as they using the torso, lHipT, ... defines (above) */
void bipedSetPosture( int* newPosture );

/** @param posture: pointer to empty array of joint angles to be filled
  * the array should be accessed using the torso, lHipT, .. defines (above) */
void bipedGetPosture( int* posture );

/** @return current Front/Back acceleration normalised between -1.0 and 1.0 */
float bipedGetAccFB( void );

/** @return current Left/Right acceleration normalised between -1.0 and 1.0 */
float bipedGetAccLR( void );

/** @return current status of the foot switches in bits 0-3 of the char,
  * The masks used to access the individual sensors are the cFootLBMask and
  * so on. */
unsigned char bipedGetFootStatus( void );


