/*
| ------------------------------------------
| Filename: wireless.c
|
| Author:   Thomas Braunl, braunl@ee.ua.edu.au, June 1998
|
| Description: 
| serial I/O over wireless link
| -----------------------------------------
*/

#include "eyebot.h"
#include <stdio.h>

void WL_SEND();
void WL_RECV();
int  WL_CD();

char str[] = "0123456789";

void preface()
{ char k;
  int  i;

  k = 0x55; /* preamble */
  for (i=0; i<10; i++)
    OSSendRS232(&k, SERIAL3);
  k = 0xff; /* lock UART */
  for (i=0; i<5; i++)
    OSSendRS232(&k, SERIAL3);
  k = 0x01; /* message start */
  for (i=0; i<2; i++)
    OSSendRS232(&k, SERIAL3);
}

void sendstr(char s[])
{ int i;

  i = 0;
  while (s[i] != 0)
  { OSSendRS232(&s[i], SERIAL3);
    LCDPrintf("%c",s[i]);
    i++;
  }
}


void main ()
{ char c,key;
  int  cnt;

  LCDMode(SCROLLING|NOCURSOR);

  LCDPrintf("Wireless\n");
  LCDMenu("SND","REC","","END");

  switch(KEYGet())
  { case KEY1: { /* SEND */
      LCDPrintf("Send:\n");
      LCDMenu("A..","Str","S.. ","END");
      OSInitRS232(SER9600, NONE, SERIAL3);

      do
      { key = KEYGet();
        WL_SEND();
        OSWait(2); /* wait ms after switch on */
        preface();
        switch (key)
        { case KEY1: c = 'A';
                     do
                     { OSSendRS232(&c, SERIAL3);
                       LCDPrintf("%c",c);
                     } while (KEYRead() != KEY4);
                     break;
          case KEY2: cnt = 0;
                     sendstr(str);
                     break;
          case KEY3: do
                     { sendstr(str);
                     } while (KEYRead() != KEY4);
                     break;
        }
        WL_RECV();
        LCDPrintf("\n");
      } while (key != KEY4);
      break;
     }

    case KEY2: { /* RECEIVE */
      cnt = 0;
      LCDPrintf("Receive:\n");
      LCDMenu(" "," "," ","END");
      OSInitRS232(SER9600, NONE, SERIAL3);
      WL_RECV();

      while (KEYRead() != KEY4)
      { if (!WL_CD()) LCDPrintf("\n%4d - wait"); /* ** */
        while (!WL_CD()) ;  /* busy wait for carrier detect */
        OSRecvRS232(&c, SERIAL3);
        LCDPrintf("%c", c);
        /* LCDPrintf("\n%4d ** %2x", cnt++, c); */
      }
      break;
     }
  }
}

