/*
 * Author: Mari Wang <mariw@tartarus.uwa.edu.au>
 * Date: 1999-11-27
 *
 * Test speed of RoBIOS functions.
 */

#include <eyebot.h>
#include <stdio.h>
#include "../timerheader.h"

int
main(int argc, char *argv[])
{
  char *function_type = "LCD functions"; /* Fill in adequate name of
                                          * functions currently being
                                          * tested */

  /* File specific variables (those needed for testing */

  image img1;
  colimage cimg1;
  char c;
  int i;

  index += init_test(function_type);

  /* Functions to be tested go here.
   * Semantics:
   * do_test(function_name, parameters);
   */
  do_test(LCDPutGraphic,(&img1));
  do_test(LCDCPutGraphic, (&cimg1));
  do_test(LCDPutImage,((BYTE*)img1));
  do_test(LCDClear,());
  do_test(LCDPutChar,(c));
  do_test(LCDSetChar,(1,1,c));
  do_test(LCDSetChar,(10,10,c));
  do_test(LCDPutString,("Testing\n"));
  do_test(LCDSetString,(1,1,"Testing\n"));
  do_test(LCDSetString,(10,10,"Testing\n"));
  do_test(LCDPutHex,(i));
  do_test(LCDPutHex1,(i));
  do_test(LCDPutInt,(i));
  do_test(LCDPutIntS,(i,6));
  do_test(LCDSetPixel,(1,1,0));
  do_test(LCDSetPixel,(1,1,1));
  do_test(LCDSetPixel,(1,1,2));
  do_test(LCDInvertPixel,(1,1));
  do_test(LCDGetPixel,(1,1));
  do_test(LCDArea,(1,1,2,2,1));
  do_test(LCDArea,(1,1,8,8,1));
  do_test(LCDArea,(1,1,32,32,1));
  do_test(LCDArea,(1,1,64,64,1));
  do_test(LCDArea,(1,1,2,2,2));
  do_test(LCDArea,(1,1,8,8,2));
  do_test(LCDLine,(1,1,1,64,1));
  do_test(LCDLine,(1,1,64,1,1));
  do_test(LCDLine,(1,1,64,64,1));
  do_test(LCDLine,(1,1,32,32,1));
  do_test(LCDLine,(1,1,1,64,2));
  do_test(LCDLine,(1,1,64,1,2));
  do_test(LCDMode,(SCROLLING));
  do_test(LCDMode,(CURSOR));
  do_test(LCDSetPos,(0,0));
  do_test(LCDSetPos,(5,5));
  do_test(LCDMenu,("one","two","thre","four"));
  do_test(LCDMenuI,(1,"one"));
  do_test(LCDMenuI,(2,"two"));
  do_test(LCDMenuI,(3,"thre"));
  do_test(LCDMenuI,(4,"four"));

  end_test();

  return 0;
}
