/**
@name randrive.c
@author Andrew Berry
@revision Peter Vanopulos
@date Original source code created on: unknown, 
      Revised: 29/11/1999
.This is a program to move the robot around to test the battery life.
*/


#include "eyebot.h"
#include <stdlib.h>

#define v_lin 7.0
#define t_lin 0.3
#define v_rot 10.0
#define t_rot 0.1   

MotorHandle     leftmotor, leftmotor;
PSDHandle       psd_front, psd_left, psd_right;
VWHandle        vw;

void main ()
{       /* write message */
        LCDMode(SCROLLING|NOCURSOR);
        LCDMenu("","","","END");

        LCDPutString("Roll on ...\n");
        vw=VWInit(VW_DRIVE,1);
        
        /* this is because #5 has stuffed up PSD */
        psd_front = PSDInit(PSD_FRONT);
        psd_left = PSDInit(PSD_LEFT);
        psd_right = PSDInit(PSD_RIGHT);
        PSDStart(psd_front, TRUE);
        PSDStart(psd_left,TRUE);
        PSDStart(psd_right,TRUE);
        VWStartControl(vw, v_lin, t_lin , v_rot, t_rot);
        
        while(KEYRead() != KEY4)
        {
          if((PSDGet(psd_front)>100 && PSDGet(psd_left)>100 && PSDGet(psd_right)>100   ) ) {
	        VWDriveStraight(vw,0.01,0.2);
	  }
          else
          { 
                LCDPutString("Backwards \n");
                VWDriveStraight(vw,-0.04,0.2);
                while(!VWDriveDone(vw)) VWDriveWait(vw);

                if((rand()%2)==0) {
                    VWDriveTurn(vw,1.57,0.6);
                LCDPutString("Turning Left \n");
		}
                else {
                    VWDriveTurn(vw,-1.57,0.6);
                    LCDPutString("Turning Right \n");
		}
		while(!VWDriveDone(vw)) VWDriveWait(vw);
          }         
        }/* end while loop */

        LCDClear();
        LCDPutString("END Button pressed\n");
}

