/*
| -----------------------------------------------------------------------------
| Filename: motor4.c
|
| Author:  Andrew Berry
|
| Description: 
| This is a program to move the robot around to test the battry life.
| -----------------------------------------------------------------------------
*/

#include "librobi/librobi.h"
#include "libimpro/improc.h"
#include "librobi/protos.h"

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "types.h" 
#include "kern.h"
#include "rs232.h"
#include "hdt.h"
#include "hdt_sem.h"

#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#define v_lin 7.0
#define t_lin 0.3
#define v_rot 10.0
#define t_rot 0.1   

MotorHandle     leftmotor;
MotorHandle     rightmotor;
PSDHandle       psd_front, psd_left, psd_right;
VWHandle        vw;
char    z;
int     i;

int main ()
{

/* disable input/output buffer */

	setvbuf (stdout,NULL,_IONBF,0); 
	setvbuf (stdin,NULL,_IONBF,0);  

/* clear display and write message */

	LCDClear();
	LCDMode(SCROLLING|NOCURSOR);
	LCDMenu("","","","END");

	printf("Roll on ...\n");

	vw=VWInit(VW_DRIVE,1);
	
	/* this is because #5 has stuffed up PSD */
	psd_front = PSDInit(PSD_FRONT);
	psd_left = PSDInit(PSD_LEFT);
	psd_right = PSDInit(PSD_RIGHT);
	PSDStart(psd_front, TRUE);
	PSDStart(psd_left,TRUE);
	VWStartControl(vw, v_lin, t_lin , v_rot, t_rot);
	
	for(;;)
	{
	  if((PSDGet(psd_front)>100 && PSDGet(psd_left)>100 && PSDGet(psd_right)>100   ))
	  {
	    printf("foward! %d %d \n",PSDGet(psd_front), PSDGet(psd_left) );
	    VWDriveStraight(vw,0.01,0.2);
	   
	  }
	  else
	  {
	    printf("run away!\n");
	    VWDriveStraight(vw,-0.04,0.2);
	    while(!VWDriveDone(vw))
	      printf(".");
    	    printf("\nturning\n");
	    if((rand()%2)==0)
	    {
	      VWDriveTurn(vw,1.57,0.6);
	      

	    }
	    else
	      VWDriveTurn(vw,-1.57,0.6);
	    while(!VWDriveDone(vw))
	      printf(">");
	  }	    
	}
	 

	return(0);
}

