/* Robot command processor system */
/* written by stephen .t .humble */
/* a command processing system */
#include <stdlib.h>
#include <stdio.h>
#include "imagination.h"
#include "language.h"
#include "drive-main.h"
#include "logger.h"
#ifndef INTEL
#include "vision-system.h"
#include "eyebot.h"
#else
#include "robot.h"
#endif
#include "logger.h"
#include "imaths.h"
#include "command.h"

#define MAXIMUMC 10
#define TICTIME 100
#define DEBUG yes

  /* this is the handler for the move to location command */
  /* it sends motor command instructions for the motor system */ 
  /* it sends completion signal of 0 when command is completed */
int command_move(command *Z)
{
  int r;
  int x,sw;
  iv2 dP,dP2;
  mx22 mx;
  track *mQ,*xp;
  xp=track_find(Z->name,Z->num);  /* get target */ 
  xp->delta(xp,&dP); /* delta returns location of target track */ 

  mQ=track_me();
  iv2_sub(&mQ->pos,&dP);  /* find difference in location */
  iv2_rotate(&dP,-(mQ->a)); /* get location relative to my direction */
  r=drive_to(&dP);          /* tel motor system where to drive to */
  if(r==1){     /* enter second stage of command into que */
    sLANCommand q;
    q.name=Z->name;
    q.num=Z->num;
    q.pri=0; 
    q.cmd=cLANExplore;
    command_add(&q);
    return(1);
  }
  return(r);
}

  /* this is the handler for the ram object to location command */
  /* quite essential for playing soccer of course */
  /* it sends motor command instructions for the motor system */ 
  /* it sends completion signal of 1 when command is completed */
int command_move2(command *Z)
{
  int res;
  int z;
  int a;
  int x;
  iv2 dP,dP2,rP,xP,mP;
  mx22 mx;
  track *mQ,*xQ,*xQ2;

  xQ=track_find(Z->name,Z->num);  /* get target */ 
  xQ->delta(xQ,&dP); /* delta returns location of target track */ 

  xQ2=track_find(Z->name2,Z->num2);  /* get target */ 
  xQ2->delta(xQ2,&dP2); /* delta returns location of target track */ 
  /* determine vector to target location */
  
  mQ=track_me();
  mQ->delta(mQ,&mP); /* delta returns location of track */ 
 
  iv2_sub(&dP,&dP2); /* find difference in location */
  /* convert to polar coordinates  */
  /* z=iv2_mag(&dP2); */
  a=iv2_angle(&dP2);
  /* target ramming vector calculation */ 
  rP.e[0]=-300;
  rP.e[1]=0;  /* make this adjustable for ramming distance */
  iv2_rotate(&rP,a);
  iv2_add(&dP,&rP);  /* now have position to ram from */
  /*
  mx22_irotate(&mx,a);
  mx22_mul(&mx,&rP,&xP);   
  */
 /* find difference in location */
  /* need function to determine direction to go in */
  /* need to rotate coordiante to robots direction of view */
   do{ /* use a cursor to advertise where i plan to goto next */
      sLANTrack c;
      c.type=cLANTrack;
      c.size=sizeof(sLANTrack);
      c.name=cLANCursor;
      c.num=1;
      c.x=rP.e[0];
      c.y=rP.e[1];
      c.v=0;
      c.a=0;
      track_advise(&c);
    }while(0);
  iv2_sub(&mQ->pos,&rP);    /* find difference in location */
  iv2_rotate(&rP,-(mQ->a)); /* get location relative to my direction */
  res=drive_to(&rP);         /* tel motor system where to drive to */
  if(res==1){              /* enter second stage of command into que */
    sLANCommand q;
    q.name=Z->name;
    q.num=Z->num;
    q.pri=0; 
    q.cmd=cLANExplore;
 /*      q.cmd=cLANMove; */
    command_add(&q);
    return(1);
  }
  return(res);
}

int cnt=0;
  /* this is the handler for the nod command */
  /* it makes the robot pan left and right */ 
  /* it sends completion signal of 0 when command is completed */
int command_look(command *Z)
{
#ifndef INTEL
  look(); /* tel vision system to nod head */
#endif
  if(OSGetCount()>Z->time+100)return(1);  /* one second to expire */
  return 0;
}

/* this is the command storage vector - commands are stored in here
and handled according to the commands received over RADIO with language.h or 
use the permanent prime directives if RADIO and language.h has failed */
command *cmds[40];

int command_copy(command *Z,sLANCommand *q)
{
  printf("add cmd %s %s %s\n",trans_code(q->cmd),
	 trans_code(q->name),trans_code(q->name2));
  Z->name=q->name;
  Z->num=q->num;
  Z->name2=q->name2;
  Z->num2=q->num2;
  Z->time=OSGetCount();
  Z->xtime=OSGetCount()+(180*100);  /* 180 seconds expire */
  Z->pri=q->pri;
  Z->cmd=q->cmd;
  switch (q->cmd){
  case cLANSpin: 
    Z->dome=command_move;
    /* Z->dome=command_spin; */
    break;
  case cLANMove: 
    Z->dome=command_move;
    Z->lock=iCMDMotors;
    break;
  case cLANPush:
    Z->dome=command_move2;
    Z->lock=iCMDMotors;
    break;
  case cLANCalibrate:
    Z->dome=drive_cal;
    Z->lock=iCMDMotors;
    break;
  case cLANExplore: 
    Z->dome=command_look;
    Z->lock=iCMDEyes;
    printf("Exploring\n");
    break;
  default:
    Z->dome=command_look;
    Z->lock=iCMDEyes;
    /*Z->dome=command_wait; */
    break;
  }
  return 1;
}

/* this is used to enter commands using */
/* robot language.h command structures */
int command_add(sLANCommand *q)
{ 
  command *Z;
  int x;
  for(x=0;x<MAXIMUMC;x++){
    if(cmds[x]==NULL){  /* add in a new directive - command */
      cmds[x]=(command *)malloc(sizeof(command));
      if(cmds[x]==NULL){
	error("no comdspace\n");
	return(0);
      }else{
	Z=cmds[x];
	command_copy(cmds[x],q);
	return(1);
      }
    }
  }
  error("cmd full\n");
  return 1;
}

int boored2(){
  int v;
  sLANCommand q;
  track *t;
  printf("boored\n");
  q.type=cLANCommand;
  q.size=sizeof(sLANCommand);
  t=track_rand();

  q.name=t->name;
  q.num=t->num;

  t=track_rand();
  q.name2=t->name;
  q.num2=t->num;
  q.pri=0; 
  q.cmd=cLANPush;
  command_add(&q);
}

/* adds various commands and crap to the que when robot is boored */
int boored(){
  sLANCommand q;
  sLANTrack c;
  printf("boored\n");
  q.type=cLANCommand;
  q.size=sizeof(sLANCommand);
  q.name=0;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANExplore;
  command_add(&q);

  /* tell robot to chase imaginary ball */
  q.name=cLANBall;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANMove;
  command_add(&q);

  /* tell robot to chase imaginary cursor ( after it's caught the ball) */
  q.name=cLANCursor;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANMove;
  command_add(&q);

  /* tell robot to chase imaginary cursor 1 ( after it's caught the ball) */
  q.name=cLANCursor;
  q.num=1;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANMove;
  command_add(&q);

  /* tell robot to push imaginary cursor to ball ( after it's caught the cursor ) */
  q.name=cLANCursor;
  q.num=0;
  q.name2=cLANBall;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANPush;
  command_add(&q);
  return(0);
}

/* adds some stuff to robots imagination at atartup */
int test_pattern(){
  sLANCommand q;
  sLANTrack c;
  printf("boored\n");
  q.type=cLANCommand;
  q.size=sizeof(sLANCommand);
  q.name=0;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANExplore;
  command_add(&q);

  q.type=cLANCommand;
  q.size=sizeof(sLANCommand);
  q.name=0;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANCalibrate;
  /* command_add(&q); */

  /* give robot an imaginary ball */
  c.type=cLANTrack;
  c.size=sizeof(sLANTrack);
  c.name=cLANBall;
  c.num=0;
  c.x=90;
  c.y=-700;
  c.v=39;
  c.a=-230;
  track_advise(&c);

  /* give robot an imaginary ball */
  c.type=cLANTrack;
  c.size=sizeof(sLANTrack);
  c.name=cLANCursor;
  c.num=0;
  c.x=90;
  c.y=-700;
  c.v=39;
  c.a=590;
  track_advise(&c);

  /* give robot an enemy to fight with */
  c.type=cLANTrack;
  c.size=sizeof(sLANTrack);
  c.name=cLANEnemy      ;
  c.num=0;
  c.x=700;
  c.y=0;
  c.v=45;
  c.a=-600;
  track_advise(&c);

  /* tell robot to chase imaginary ball */
  q.name=cLANCursor;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANMove;
  command_add(&q);

  /* tell robot to chase imaginary cursor ( after it's caught the ball) */
  q.name=cLANBall;
  q.num=0;
  q.name2=0;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANMove;
  command_add(&q);

  /* tell robot to push imaginary cursor to ball ( after it's caught the cursor ) */
  q.name=cLANCursor;
  q.num=0;
  q.name2=cLANBall;
  q.num2=0;
  q.pri=0; 
  q.cmd=cLANPush;
  /* command_add(&q); */
  return(0);
}

/* process commands in command que - commands in que are numbered- and 
their type-priority are taken into consideration - this routine should 
be called alot since it directly controls the responce time of the 
motor system ie 10-100 times a second */
int command_loop()
{
  int x;
  command *Z;
  int locks=0;
  int t=0;
  int drive=0;
  for(x=0;x<MAXIMUMC;x++){
    if(cmds[x]==NULL)continue; /* no command */
    Z=cmds[x];  /* command to process */
    t++;
    if(Z->lock&locks!=0){
      continue;  /* exclusive locked out commands */
    }
    /* if(Z->xtime<OSGetCount())delete_cmd()); */
    locks |= Z->lock; /* lock hardware */
    if(Z->dome(Z)==1){
      cmds[x]=NULL; /* call handler for command and check for completion */
      continue;
    }
    if(Z->xtime<OSGetCount()){  /* timeout command */
      cmds[x]=NULL; /* call handler for command and check for completion */
      printf("command timed out");
    }

  }
  if(t==0)boored(); /* we had better give the robot something to do */
  return(1);
}
/* process commands in command que - commands in que are numbered- and 
their type-priority are taken into consideration - this routine should 
be called alot since it directly controls the responce time of the 
motor system ie 10-100 times a second */
int command_init()
{
  int x;
  for(x=0;x<MAXIMUMC;x++)cmds[x]=NULL;
  return(1);
}














