/*  track stores coordinates and descriptions of objects,  */
/*  allows a model of the field to be stored , locations of other */
/*  robots and the ball.  */
/* this is used to store the location and other information about */
/* Tracked item's (including self */
#ifndef COMMAND
#include "imaths.h"
#include "language.h"
#include "ll.h"
#include "imagination.h"

/* this is a structure to describe commands which our robot is to perform */
/* the command system can perform commands in parallel or in sequences */ 
/* commands lock the hardware they use:- preventing others from being */ 
/* completed */
typedef struct _command{
  node l;
  char type,size;
  char cmd,pri;
  char name,num;
  char name2,num2;
  int lock;
  int time;
  int xtime;
  int (*dome)(struct _command *); 
 /* object based routine to call */
} command;

/* command exclusive locks */  
#define iCMDMotors 1<<0;
#define iCMDEyes 1<<1;

int command_add(sLANCommand *);
int command_loop();
int command_init();

#define COMMAND yes
#endif












