#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "imaths.h"
#ifndef INTEL
#include "librobi/librobi.h"
#include "eyebot.h"
#endif
iv2 cps_dir;
iv2 cps_min;
iv2 cps_max;
iv2 origin;

/* returns -1 on failure */
/* 0 to THREE60 on success */ 
int compass_read()
{   
  int y;
  int x;
  int b;
  iv2 tmp;
  static int cnt=0;
  static int xy=0;
  b=(xy&1);
  cnt++;
#ifndef INTEL
  OSGetAD(2+b);
#endif
  if(cnt<50)return(-1);
  cnt=0;
#ifndef INTEL
  cps_dir.e[b]=OSGetAD(2+b);
#endif
  if(cps_dir.e[0]<200 || cps_dir.e[1]<200){
    printf("no compass");
    return(-1);
  }
  xy++;
  /* autocallibrate */
  if(cps_dir.e[b]>=cps_max.e[b])cps_max.e[b]=cps_dir.e[b];
  if(cps_dir.e[b]<=cps_min.e[b])cps_min.e[b]=cps_dir.e[b];
  iv2_copy(&cps_min,&origin);
  iv2_add(&cps_max,&origin);
 for(x=0;x<2;x++){
   origin.e[x]=origin.e[x]/2;
 }
 skip:
 iv2_copy(&origin,&tmp);
 iv2_sub(&cps_dir,&tmp);
 y=iv2_angle(&tmp);  
  if(y<0)y=THREE60+(y%THREE60);
  if(y>THREE60)y=y%THREE60;
  return(y);
}

#define CZERO 512
int compass_init()
{ 
 int x;
 for(x=0;x<2;x++){
   cps_min.e[x]=CZERO-100; 
   cps_max.e[x]=CZERO+100; 
 }
 return(1);
}

compass_display()
{
    int angle;
    angle=compass_read();
    if(angle>0){
      printf("cps=%d,%d\n",cps_dir.e[0],cps_dir.e[1]);
      printf("OO=%d,%d\n",origin.e[0],origin.e[1]);
      printf("min=%d,%d\n",cps_min.e[0],cps_min.e[1]);
      printf("max=%d,%d\n",cps_max.e[0],cps_max.e[1]);
      printf("ang=%d\n",angle);
    }
    return(0);
}
