/*   motor controller
*/
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#ifdef INTEL
#include "robot.h"
#else 
#include "eyebot.h"
#endif
#include "quad.h"
#include "imaths.h"
#include "imagination.h"
#include "command.h"
#include "drive-main.h"

#define DDRES 10000
/*
#define DEBUG yes
*/
/************************************************************************/
/* globals - constants which are set at beginning */
/*
MotorHandle motor_l;
MotorHandle motor_r;
QuadHandle quad_l; 
QuadHandle quad_r;
*/

quad quad_l; 
quad quad_r;
/* upos is um resolution location of robot */
iv2 upos;

struct motor_sys Q[1000];

int tq; /* memory track pos */
int drive_diff;
int drive_speed;
int learn_mode;

#define MM_RAM 1;
#define MM_BLOCK 1;
#define MM_PUSH 1;
#define MM_DEFLECT 1;
#define MM_CATCH 1;
#define MM_ESCORT 1;

int drive_switch=1;
#define RMAX 80
#define FMAX 100
#define DMAX 100
#define DRIVEMAX 200

int drive_off(){
  drive_switch=0;
  return(0);
}
int drive_on(){
  drive_switch=1;
  return(0);
}

/************************************************************************/
/* how about i include a learning mode for robots to be taught a lesson */ 
int drive_learn(int yes)
{
  if(yes==0){
    learn_mode=1;
  }else{
learn_mode=0;
  }
  return(0);
}

/************************************************************************/
int drive_set(int speed,int lr)
{   
  drive_speed=speed;
  drive_diff=lr;
  return(1);
}

/************************************************************************/
int drive_me()
{
  return(1);
}
/************************************************************************/
/*   initilaise motors and quadrature counters settup global varables */
int drive_init()
{
  quad_init(&quad_l,QUAD_LEFT,LEFTMOTOR);
  quad_init(&quad_r,QUAD_RIGHT,RIGHTMOTOR);
  drive_on();
  /*
  if (!quad_r)
    return(0);
    */
  /*
    MOTORDrive (motor_r,50);
    MOTORDrive (motor_l,-50);
  */
  return(0);
}

/************************************************************************/
/* work out motor control varables- this is used for pre emptive motor control */
/* this routine allows compensation for different surfaces, motors, wheels etc */ 
/* i should use some sort of simplex problem solver algorythm perhaps */
/* parameters found are accelleration time to max velocity, max velocity */
/* coast to stop time, these are written into tables which this routine */
/* generates from it's measurments */
/************************************************************************/
/* this routine is called every main loop to give motor feedback
     and control, user provides the feedback and mode signals  */ 
int drive_loop()
{
  static int ll,lr; /* previous quad value */
  struct motor_sys *ZZ=&Q[tq];
  int l=0;
 int r=0;
  int sl,sr;
  if(tq++>1000)tq=0; /* circular buffer */
  ZZ->time=OSGetCount();
  ZZ->l_quad=ll-l;
  ZZ->r_quad=lr-r;
  ll=l;
  lr=r;
  sl=ZZ->speed;
  sr=ZZ->speed;
  /* formula for position calculation is not required for real time
     - can be analysed later on though */
  /*
  if(learn_mode!=1){ 
    MOTORDrive(motor_l,ZZ->l_speed);
    MOTORDrive(motor_r,ZZ->r_speed);
  }
  */
  return(1);
}

/************************************************************************/
/* work out motor control varables- this is used for pre emptive motor control */
/* this routine allows compensation for different surfaces, motors, wheels etc */ 
/* i should use some sort of simplex problem solver algorythm perhaps */
/* parameters found are accelleration time to max velocity, max velocity */
/* coast to stop time, these are written into tables which this routine */
/* generates from it's measurments */
/************************************************************************/
/* this routine is called periodically to record and update robot location
   using quad local sensors */
/* has a prefix to quadrature resolution problem */
int drive_tracker()
{
  int x=0;
  track *Z;
  iv2 pos;
  int angle;
  static int l=0;
  static int r=0;
  int l2=0;
  int r2=0;
  Z=track_me();
  l+=quad_read(&quad_l);  /* read distance moved */
  r+=quad_read(&quad_r);
/*    printf("quads %d,%d",l,r); */
  /* need to use the Lowest common denominator to prevent resolution problems */
  if(abs(l)>32){
    l2=l-(l%32);
    l-=l2;
  }
  if(abs(r)>32){
    r2=r-(r%32);
    r-=r2;
  }
  if(l2!=0 || r2!=0){
  int dt,t;
    t=OSGetCount(); /* find dt */
    dt=t- (Z->time);
    Z->time=t;
    if(dt==0){
      printf("dt==0\n");
    }else{
    /* calculate distance moved and rotation */
    ddrive(l2,r2,WHEELBASE*TICKSPM/1000,&pos,&angle);   
    for(x=0;x<2;x++) pos.e[x]=pos.e[x]*1000; /* back to mm from tics */
    for(x=0;x<2;x++) pos.e[x]=pos.e[x]/TICKSPM;
    iv2_rotate(&pos,Z->a);
    Z->v=iv2_mag(&pos)*100/dt;  /* velocity */
    iv2_add(&pos,&Z->pos);
    Z->av=angle*100/dt;  /* angular velocity */
    Z->a+=angle;
    }
  }
  return(1);
}

/* this routine is called every main loop to record and update robot location
 using local sensors */ 
/* this routine is stuffed does a post fix to the resolution problem */
int drive_tracker_stuffed()
{
  int x;
  track *Z;
  iv2 pos;
  int angle;
  int l,r;
  Z=track_me();
  l=quad_read(&quad_l);  /* read distance moved */
  r=quad_read(&quad_r);

  /* calculate distance moved in tics and rotation */
  ddrive(l*DDRES,r*DDRES,(WHEELBASE*TICKSPM/1000)*DDRES,&pos,&angle);   
  for(x=0;x<2;x++) pos.e[x]=pos.e[x]*1000; /* to 1/DDRES mm from tics */
  for(x=0;x<2;x++) pos.e[x]=pos.e[x]/TICKSPM;
  iv2_rotate(&pos,Z->a);
  iv2_add(&pos,&upos);

  /* need to use um resolution to prevent resolution problems */
  for(x=0;x<2;x++){
    if(abs(upos.e[x])>=DDRES){
      int d=upos.e[x]-(upos.e[x]%DDRES);
      upos.e[x]-=d;
      Z->pos.e[x]+=(d/DDRES);
    }
  }
  printf("dres %d,%d\n",upos.e[0],upos.e[1]);
  Z->a+=angle;
  return(1);
}

#define RANGE 100
/******************************************************************/
  /* ipos is the relative position we want the robot to drive to */
  /* the user needs to do coordiante conversions etc to */
  /* produce relative coordinates */
int drive_to(iv2 *z)
{
  int f=0;
  int y=0;
  int motor_ls=0;
  int motor_rs=0;
  track *Z;
  if((z->e[0]<RANGE) && (z->e[0]> -RANGE) && (z->e[1]<RANGE) && (z->e[1]> -RANGE)){
    motor_ls=0;
    motor_rs=0;
    printf("Drive Done\n");
    return(1); /* mission accomplished */
  }
#ifdef DEBUG2
  printf("target=%d,%d\n",z->e[0],z->e[1]);
#endif
  z->e[0]=-(z->e[0]);  
  Z=track_me();
  y=iv2_angle(z);  /* get angle to allignment */
  y+=Z->av;        /* include angular velocity in allignament */
  if(y<0)y=THREE60+(y%THREE60) ;
  if(y>THREE60)y=y%THREE60;
  y-=(THREE60/2);  /* convert from 0 to 2 pie to +-pie */

#ifdef DEBUG2
  printf("angle=%d\n",y);
#endif
  /* y=(z->e[1]); */
  /* how many units is full drive equal to about 1/4 th of a circle */
  y=(y*4*100)/THREE60;

  motor_ls=y;
  motor_rs=-y;
  if(motor_ls>RMAX)motor_ls=RMAX;
  if(motor_ls<-RMAX)motor_ls=-RMAX;
  if(motor_rs>RMAX)motor_rs=RMAX;
  if(motor_rs<-RMAX)motor_rs=-RMAX;

  f=FMAX-abs(y);
  if(f<0)f=0;
  motor_ls+=f;
  motor_rs+=f;
  if(motor_ls>FMAX)motor_ls=FMAX;
  if(motor_ls<-FMAX)motor_ls=-FMAX;
  if(motor_rs>FMAX)motor_rs=FMAX;
  if(motor_rs<-FMAX)motor_rs=-FMAX;

  if(drive_switch==0){
    printf("drive off\n");
    motor_ls=0;
    motor_rs=0;
  }     
  quad_drive(&quad_l,motor_ls);
  quad_drive(&quad_r,motor_rs);
#ifdef DEBUG
  printf("drive=%d,%d",motor_ls,motor_rs);
#endif
  return(0);
}

/******************************************************************/
/* this utalises a self adjusting motor drive system designed to */
/* compensate for drive inertia and thus allow better control    */ 
/* multiple types of feedback are used */
/* basically thus works by using full power turning , it looks at the */
/* inertia table and determines the breaking time required to make the angle */
/* and if we are in the breaking region it uses revererse breaking */
int Turbo_drive(iv2 *z)
{
  int f=0;
  int y=0;
  int x=0;
  int motor_ls=0;
  int motor_rs=0;
  int av;
  track *Z;
  iv2 pos;
  int l,r;
  if((z->e[0]<RANGE) && (z->e[0]> -RANGE) && (z->e[1]<RANGE) && (z->e[1]> -RANGE)){
    printf("drive done\n");
    return(1); /* mission accomplished */
  }
  z->e[0]=-(z->e[0]);  
  y=iv2_angle(z);  /* get angle to allignment */
  Z=track_me();
  av=Z->av;  /* what is our present angular velocity */
  /* lookup angle for av */
  
  motor_ls=y;
  motor_rs=-y;
  if(motor_ls>RMAX)motor_ls=RMAX;
  if(motor_ls<-RMAX)motor_ls=-RMAX;
  if(motor_rs>RMAX)motor_rs=RMAX;
  if(motor_rs<-RMAX)motor_rs=-RMAX;

  f=FMAX-abs(y);
  if(f<0)f=0;
  motor_ls+=f;
  motor_rs+=f;
  if(motor_ls>FMAX)motor_ls=FMAX;
  if(motor_ls<-FMAX)motor_ls=-FMAX;
  if(motor_rs>FMAX)motor_rs=FMAX;
  if(motor_rs<-FMAX)motor_rs=-FMAX;

  if(drive_switch==0){
    printf("drive sqwitched off");
    motor_ls=0;
    motor_rs=0;
  }     
  quad_drive(&quad_l,motor_ls);
  quad_drive(&quad_r,motor_rs);
#ifdef DEBUG
  printf("drive=%d,%d",motor_ls,motor_rs);
#endif
  return(0);
}

/******************************************************************/
typedef struct _drive_cmd{
  void *next;  /* linkage */
  void *prev;  /* linkage */
  int cmd;
  int ref;
  int state;
  int done;
  int time;  /* completion time  */
  int i;
  int t[DRIVEMAX];
  int dv[DRIVEMAX];
  int v[DRIVEMAX];
  int a[DRIVEMAX];
  int av[DRIVEMAX];
}drive_cmd;

drive_cmd drive_head;

/******************************************************************/
#ifdef CRAP
drive_cmd *drive_cmd_add(int (*dome)(drive_cmd *))
{  
  int x;
  drive_cmd *Z,*Zl;
  Z=&drive_head;
  /* walk to end */
  while((Z->next)!=NULL){
    Z=(drive_cmd *)Z->next;
  } 
  /* add new node */
  Z->next=malloc(sizeof(drive_head));
  if(Z->next==NULL){
    perror("outa memory\n");
    return(NULL);
  }
  /* link */
  Zl=Z;
  Z=(drive_cmd *)Z->next;
  Z->prev=Zl;
  Z->dome=dome;
  Z->done=0;
  Z->next=NULL;
  /* initalise command structure */
  Z->time=OSGetCount();
  Z->state=0;
  return(Z);
}
#endif

/* drive read commands */
#define cDRVLeft 0
#define cDRIRight 1
#define cDRVFront 2

#define STOPPED (abs(X->av)<2)
#define SPINLEFT (X->av>0) 
#define SPINRIGHT (X->av<0)

void record()
{
  printf("calibrating\n");
  int dt,da;
  drive_cmd *Z;
  track *X;
  Z=&drive_head;
  X=track_me();
  dt=OSGetCount()- Z->time;
  da=X->a - Z->ref;
  Z->v[Z->i]=da; /* plot curve */
  Z->dv[Z->i]=X->av; /* plot curve */
  Z->t[Z->i]=dt; /* plot curve */
  Z->i++;
  return;
}
/*
void compile(){
  drive_cmd *Z;
  int x,dt,da;
  Z=&drive_head;
  for(x=0;x<Z->i;x++){
    if(Z->dv[x]<0)break;
  }
  int c,t;
  c=0;
  for(;x>0;x--){
    t+=Z->dv[x];
    Z->a[c]
   c++;
  }
  drive_cmd *Z;
  track *X;
  X=track_me();
  dt=OSGetCount()- Z->time;
  da=X->a - Z->ref;
  Z->i++;
  return;
}
*/

/* run a drive system calibration manuver */
int drive_cal(command *C)
{
  drive_cmd *Z;
  track *X;
  Z=&drive_head;
  switch(Z->state){
  case 0:
    quad_drive(&quad_l,0);
    quad_drive(&quad_r,0);
    /* wait for robot to stop */
    if(STOPPED){
      printf("stopped \n");
      X=track_me();
      Z->ref=X->a;  /* set reference */
      Z->state++;
      Z->time=OSGetCount();
      break;
    }
  case 1:
    quad_drive(&quad_l,DMAX);
    quad_drive(&quad_r,-DMAX);
    if(Z->time+200<OSGetCount()){ /* ramp up 2 secs */
      Z->state++;
      Z->time=OSGetCount();
    }
    break;
  case 2:
    quad_drive(&quad_l,-DMAX);  /* power break */
    quad_drive(&quad_r,DMAX);
    record();   
    if(Z->time+400<OSGetCount()){ /* ramp down 4 secs */
      Z->state++;
      quad_drive(&quad_l,0);
      quad_drive(&quad_r,0);
    }
    break;
  default:
    return(1); /* mission accomplished */
  }
  return(0);
}

/******************************************************************/
/* this utalises a self adjusting motor drive system designed to */
/* compensate for drive inertia and thus allow better control */ 
/* 2 types of feedback are used - one from the quadrature decoders */
/* and one from integrated external sensors ie comapss and Global Vision */
/*
int Turbo_drive_init()
{
  drive_cmd *Z,*Zl;
  int x;
  Z=drive_cmd_add( drive_cal2 );
  return(0);
}
*/


/* perform all drive callibration commands */
/*
int Turbo_drive_cal()
{
  drive_cmd *Z;
  int res;
  Z=&drive_head;
  while((Z->next)!=NULL){
    Z=Z->next;
    if(Z->done!=1){
      res=Z->dome( Z );
      break;
    } 
  }
  return(res);
} 
*/



























