#include "imaths.h"
#include "imagination.h"
#include "command.h"
#define WHEELBASE 84
#define TICKSPM 3235

int drive_loop();
int drive_init();
int drive_to(iv2 *);
int drive_tracker();
int drive_off();
int drive_on();
int drive_cal(command *);

/* we can store entire play sequences in this structure for later playback and use it to 
   optimise our play */
struct motor_sys
{
  /* robots sensor and tracking values */ 
  int time;
  int x_apos,y_apos;
  int angle;
  int l_quad,r_quad; /* quadrature input change since last time */
  int l_speed, r_speed;   /* motor signal output value */
  int speed;  /* used to tell robot urgency - speed we want to go at */
  /* used to advise of relative target location and velocity */
  int tx_pos,ty_pos;    /* complex vector to target */
  int tx_vel,tr_vel;    /* target velocity */ 
  /* used to advise of action - would be decided by either by MCP or robot */
  int mode;  /* do i escort, push ,ram , intercept , block ? */
  int slide;  /* slide do i want a slide or steer to target ratio 0 to 255 */
};
