/* Robotic imagination system */
/* written by stephen .t .humble */
/* this is the object tracking and environment storage system */
/* also a command processing system */
#include <stdlib.h>
#include <stdio.h>
#include "imagination.h"
#include "language.h"
#include "drive-main.h"
#include "logger.h"
#ifndef INTEL
#include "vision-system.h"
#include "eyebot.h"
#else
#include "robot.h"
#endif
#include "robocup-shapes.c"
#include "logger.h"
#include "imaths.h"

#define MAXIMUM 190
#define TICTIME 100

#define DEBUG yes

/* this is used to track objects */
/* may work better if i used a linked list instead */ 
track *trk[MAXIMUM];
track track_head;
track track_tail;

  /* this command finds my track */    
track *track_me()
{ 
  track *v;
  v=track_find(cLANFriend,0);
  return(v); 
}

int track_init()
{
  track *z;
  int x;
  sLANTrack c;
  for(x=0;x<MAXIMUM;x++)trk[x]=NULL;
  z=&track_head;
  z->name=0;
  z->num=0;
  z->a=0;
  z->v=0;
  z->delta=track_linear_predict;
  /* add myself to tracker */ 
  /*
    c.type=cLANTrack;
    c.size=sizeof(sLANTrack);
    c.name=cLANFriend;
    c.num=0;
    c.x=0;
    c.y=0;
    c.a=0;
    c.v=0;
    track_advise(&c);
  */
  data_loader();
  return(0);
}

/* function to link tracks together and return pointer to head */
track *track_gethead()
{
  int x;
  sLANTrack c;
  track *Z,*Zl;
  Z=&track_head;
  Z->prev=NULL;
  for(x=0;x<MAXIMUM;x++)if(trk[x]!=NULL){
    Z->next=trk[x];
    Zl=Z;
    Z=Z->next;
    Z->prev=Zl;
  }
  Z->next=NULL;
  return(&track_head);
}

/* this command finds the track structure refered to by a name code */    
track *track_find(char name,char num)
{ 
  int x;
  for(x=0;x<MAXIMUM;x++){
    if(trk[x]==NULL)continue; /* no track */
    if( (name==trk[x]->name) && (num==trk[x]->num) )return(trk[x]);
  }
  return(NULL);
}

/* this command finds a random track */
track *track_rand()
{ 
  track *ob;
  int v;
  v=(20.0*rand())/RAND_MAX;
  printf("random =%d \n",v);
  do{
  ob=track_gethead();
  while((ob->next)!=NULL){
    ob=ob->next;
    v--;
    if(v<=0)return(ob);
  }
  }while(v>0);
  return(NULL);
}

#define BOUNDARY 2000

/* this is used to predict the x,y location of the object at time of call */ 
/* this a virtual function so i can define different prediction behaviors */
/* in future improvements */
int track_linear_predict(struct _track *Z,iv2 *q)
{
  int x;
  int dT;
  dT=OSGetCount();
  if(dT !=Z->stime) /* keep predictions up to date */
    {
      iv2_copy(&Z->pos,&Z->lpos);  /* record last position */
      dT-=Z->stime;
      Z->stime=OSGetCount();  
      for(x=0;x<2;x++)Z->pos.e[x]+=((Z->vel.e[x]*dT)/TICTIME);
      /* boundary deflector for testing purposes only */
      if(Z->pos.e[0]>BOUNDARY)Z->vel.e[0]=-abs(Z->vel.e[0]);
      if(Z->pos.e[0]<-BOUNDARY)Z->vel.e[0]=abs(Z->vel.e[0]);
      if(Z->pos.e[1]>BOUNDARY)Z->vel.e[1]=-abs(Z->vel.e[1]);
      if(Z->pos.e[1]<-BOUNDARY)Z->vel.e[1]=abs(Z->vel.e[1]);
    }
  iv2_copy(&Z->pos,q);
  return(1);  
}

int track_copy(track *Z,sLANTrack *q)
{
  static int color=1;
  mx22 a;
  iv2 b;
      Z->name=q->name;
      Z->num=q->num;
      Z->color=color++;  /* randomly assign colors to objects */
      if(color>7)color=1;
      Z->time=OSGetCount();
      Z->pos.e[0]=q->x;
      Z->pos.e[1]=q->y;
      /* temporary solution
      Z->vel.e[0]=q->v;
      Z->vel.e[1]=q->a;
      */
      /* convert from polar to rectangluar velocity info */
      mx22_irotate(&a,q->a);
      b.e[0]=q->v;
      b.e[1]=0;
      mx22_mul(&a,&b,&Z->vel);
      Z->a=q->a;
      Z->delta=track_linear_predict;
  return 1;
}

/* print all shapes in robots mind */
int track_print_all()
{
  track *ob;
  ob=track_gethead();
  while((ob->next)!=NULL){
    ob=ob->next;
    track_print(ob);
  }
  return 1;
}

/* print some info about a shape in robots mind */
int track_print(track *Z)
{
  printf("%s%d@%d,%d\n",trans_code(Z->name),Z->num,Z->pos.e[0],Z->pos.e[1]);
  printf("ang=%d\n",Z->a);
  printf("x1%d,Y1%d\n",Z->sh.x[0],Z->sh.y[0]);
  return 1;
}

  /* allocate and add in a new object track */
track *track_add()
{
  int x;
  for(x=0;x<MAXIMUM;x++){
    if(trk[x]==NULL){
      trk[x]=(track *)malloc(sizeof(track));
      if(trk[x]==NULL){
	error("no track space left");
	return((track *)0);
      }else{
	return(trk[x]);
      }
    }
  }
  error("no track space left");
  return((track *)0);
}

/* this is used to update the tracking system database using */
/* robot language.h track structures */
int track_advise(sLANTrack *q)
{ 
  track *Z;
  Z=track_find(q->name,q->num);
  if(Z==NULL)Z=track_add();
  track_copy(Z,q);
  return 1;
}








