/*  track stores coordinates and descriptions of objects,  */
/*  allows a model of the field to be stored , locations of other */
/*  robots and the ball.  */
/* this is used to store the location and other information about */
/* Tracked item's (including self */
#ifndef IMAGINATION
#include "imaths.h"
#include "language.h"
#include "ll.h"

/* this is a comment */
#define cTRACKZone 'z'
#define cTRACKBall 'b'
#define cTRACKAlive 'a'

typedef struct _track{
  struct _track *next;
  struct _track *prev;
  char name,num;
  char type;
  char size,speed,mode,age;
  int color;
  int time;  /* last update */
  int stime;  /* last prediction update */
  iv2 lpos;  /* last pos */
  iv2 pos;
  iv2 vel;
  polygon sh;
  int v;  /* velocity */
  int a;  /* angle */
  int av;  /* angular velocity  */
  int (*delta)( struct _track *,iv2 *);
  /* this is an oo virtual function which returns the x,y values */
  /* of the track at present time */
  /* next version will instead return formula parameters to allow */
  /* for time based interception routines */
}track;

int track_init();
int track_advise(sLANTrack *);
track *track_find(char,char);
track *track_me();
track *track_add();
track *track_rand();
track *track_gethead();
int test_pattern();
int track_linear_predict(struct _track *Z,iv2 *q);
int track_print(track *);
int track_print_all();

#define IMAGINATION yes
#endif












