 /* Initiger 3D Mathematics routines written by Stephen .T .Humble  */
#include <stdio.h>
#include <math.h>
#include "imaths.h"

int isintab[THREE60];
int irtantab[(MULBASE/4)+1];

/* call this to init sine table and inverse sin any other tables */
void imaths_init()
{
  int x;
  /* 2pie sine table */
  for(x=0;x<THREE60;x++){
    isintab[x]=(int)(MULBASE*sin((M_PI*2/THREE60)*x));
  }
  /* 0 to MULBASE/4 atan table */ 
  for(x=0;x<=(MULBASE/4);x++){
    irtantab[x]=(int)(THREE60PIE*atan((float)x/(MULBASE/4)));
  /*  printf("tantable x=%d angle= %d",x,irtantab[x]); */
  }
  return;
}

int irtan(int v)
{
  if(v<0){ 
    return( -(irtantab[-v]));
  }else{
    return(irtantab[v]);
  }
  return(-1);
}

int isin(int v)
{
  if(v<0)v=THREE60+(v%THREE60) ;
  if(v>THREE60)v=v%THREE60 ;
  return(isintab[v]);
}

int icos(int v){
  v+=(THREE60/4);
  if(v<0)v=THREE60+(v%THREE60) ;
  if(v>THREE60)v=v%THREE60 ;
  return(isintab[v]);
}

 /* multiply mx (3,3) by I (3) result into O (3) */
void mx33_mul( mx33 *mx,iv3 *I,iv3 *O)
{
  int r,c,p;
  p=0;
  for(r=0;r<3;r++){
    O->e[r]=0;
  }
  for(r=0;r<3;r++){
    for(c=0;c<3;c++,p++){
      O->e[r]+=mx->e[p]*I->e[c];
    }
  }
  for(r=0;r<3;r++){
    O->e[r]=O->e[r]>>PRECISION;
  }
}

void mx33_rmul( mx33 *mx,iv3 *I,iv3 *O)
{
  int r,c,p;
  p=0;
  for(r=0;r<3;r++){
    O->e[r]=0;
  }
  for(r=0;r<3;r++){
    for(c=0;c<3;c++,p++){
      O->e[r]+=mx->e[p]*I->e[c];
    }
  }
  for(r=0;r<3;r++){
    O->e[r]=O->e[r]>>PRECISION;
  }
}

void mx22_rmul(mx22 *mx,iv2 *I,iv2 *O)
{
 int r;
  O->e[0]=mx->e[0]*I->e[0]+mx->e[2]*I->e[1];
  O->e[1]=mx->e[1]*I->e[0]+mx->e[3]*I->e[1];
  for(r=0;r<2;r++){
    O->e[r]=O->e[r]>>PRECISION;
  }
}

 /* copy         mtx b =  mtx a */
void mx33_copy(mx33 *A,mx33 *B)
{
int y;
 for(y=0;y<9;y++){
 B->e[y]=A->e[y];
 }
}

 /* copy         mtx b =  mtx a */
void mx22_copy(mx22 *A,mx22 *B)
{
int y;
 for(y=0;y<4;y++){
 B->e[y]=A->e[y];
 }
}

int mx33_div(mx33 *mx,fv3 *pt1,fv3 *pt2)
{
  float t,dv;
  int i,j,k,max;
  for(i=0;i<3;i++){		/* row */
    max=i;
    for(j=i+1;j<3;j++)		/* hunt for biggest */
      if(abs(mx->e[j+3*i])>abs(mx->e[max+3*i]))max=j;

    t=pt1->e[i];		/*  swap points */
    pt1->e[i]=pt1->e[max];	pt1->e[max]=t;

    for(k=i;k<3;k++)	/* swap rows */
      { t=mx->e[i+3*k];
      mx->e[i+3*k]=mx->e[max+3*k];
      mx->e[max+3*k]=(int)t;}

    for(j=i+1;j<3;j++){
      if(mx->e[i+3*i]==0)printf("error div zero "); /* subtract rows to eliminate */
      dv=mx->e[j+3*i]/mx->e[i+3*i];
      pt1->e[j]-=pt1->e[i]*dv; 
      for(k=2;k>=i;k--)
	mx->e[j+3*k]-=(int)(mx->e[i+3*k]*dv);
    }
  }
  /* substitute */
  for(j=2;j>=0;j--){
    t=0.0;
    for(k=j+1;k<3;k++)t+=mx->e[j+3*k]*pt2->e[k];
    pt2->e[j]=(pt1->e[j]-t)/mx->e[j+3*j];
  }
  return(0);
}

void mx33_print( mx33 *A)
{
  printf("| %d\t%d\t%d\t |\n",A->e[0],A->e[1],A->e[2]);
  printf("| %d\t%d\t%d\t |\n",A->e[3],A->e[4],A->e[5]);
  printf("|_%d\t%d\t%d\t_|\n",A->e[6],A->e[7],A->e[8]);
}

void mx22_print(mx22 *A)
{
  printf("| %d\t%d\t |\n",A->e[0],A->e[1]);
  printf("|_%d\t%d\t_|\n",A->e[2],A->e[3]);
}

void iv3_print(iv3 *A)

{
  printf("[ %d , %d , %d ]\n",A->e[0],A->e[1],A->e[2]);
}
void iv2_print(iv2 *A)
{
  printf("[ %d , %d ]\n",A->e[0],A->e[1]);
}

void mx33_rotatez(mx33 *mx,int x)
{
  mx->e[8]=MULBASE*1;
  mx->e[5]=MULBASE*0;
  mx->e[2]=MULBASE*0;
  mx->e[6]=MULBASE*0;
  mx->e[7]=MULBASE*0;
  mx->e[0]=icos(x);
  mx->e[1]=isin(x);
  mx->e[3]=isin(x);
  mx->e[4]=-icos(x);
}

void mx22_mul(mx22 *mx,iv2 *I,iv2 *O)
{
  int r;
  O->e[0]=(mx->e[0]* I->e[0])+ (mx->e[1]* (I->e[1]));
  O->e[1]=(mx->e[2]* I->e[0])+ (mx->e[3]* (I->e[1]));
  for(r=0;r<2;r++){
    O->e[r]=O->e[r]>>PRECISION;
  }
}

void mx22_irotate(mx22 *mx,int x)
{
  mx->e[0]=icos(x);
  mx->e[1]=-isin(x);
  mx->e[2]=isin(x);
  mx->e[3]=icos(x);
}

void mx33_rotatey(mx33 *mx,int y)
{
  mx->e[4]=MULBASE*1;
  mx->e[5]=MULBASE*0;
  mx->e[7]=MULBASE*0;
  mx->e[3]=MULBASE*0;
  mx->e[1]=MULBASE*0;
  mx->e[0]=icos(y);
  mx->e[2]=isin(y);
  mx->e[6]=-isin(y);
  mx->e[8]=icos(y);
}

void mx33_rotatex(mx33 *mx,int y)
{
  mx->e[0]=MULBASE*1;
  mx->e[1]=MULBASE*0;
  mx->e[2]=MULBASE*0;
  mx->e[3]=MULBASE*0;
  mx->e[6]=MULBASE*0;
  mx->e[4]=icos(y);
  mx->e[5]=isin(y);
  mx->e[7]=-isin(y);
  mx->e[8]=icos(y);
}

void iv3_sub(iv3 *A,iv3 *B)
{
  B->e[0]-=A->e[0];	B->e[1]-=A->e[1];	B->e[2]-=A->e[2];
}

void iv3_add(iv3 *A,iv3 *B)
{
  B->e[0]+=A->e[0];	B->e[1]+=A->e[1];	B->e[2]+=A->e[2];
}

void iv3_copy(iv3 *A,iv3 *B)
{
  B->e[0]=A->e[0];	B->e[1]=A->e[1];	B->e[2]=A->e[2];
}

void iv2_sub(iv2 *A,iv2 *B)
{
  B->e[0]-=A->e[0];	B->e[1]-=A->e[1];  
}

void iv2_add(iv2 *A,iv2 *B)
{
  B->e[0]+=A->e[0];	B->e[1]+=A->e[1];  
}

int iv2_mag(iv2 *A)
{
  return((int)sqrt( (A->e[0]*A->e[0]) + (A->e[1]*A->e[1]) ));
}

/* rotate point around origin by angle a */
int iv2_rotate(iv2 *A,int a)
{
  mx22 mx;
  iv2 B;
  iv2_copy(A,&B);
  mx22_irotate(&mx,a);
  mx22_mul(&mx,&B,A);
  return(1);
}

int iv2_angle(iv2 *A)
{
  int x,y,s,a;
  int ud=0;  /* octant codes */
  int lr=0;
  int yx=0;
  x=A->e[0];
  y=A->e[1];
  if(y<0){
    y=-y;
    ud=1;
  }
  if(x<0){
    x=-x;
    lr=1;
  }
  if(y>x){
    s=x;
    x=y;
    y=s;
    yx=1;
  }
  a=y*MULBASE/4;
  if(x!=0){
    a=(int)a/(int)x; /* result is from MULBASE to 0 */
  }else{
    a=0;
  } 
#ifdef DEBUG
  printf("a foctor=%d",a);
#endif
  a=irtan(a);
#ifdef DEBUG
  printf("angle from table=%d",a);
#endif
  if(yx==1)a=(THREE60/4)-a;
  if(ud==1)a=-a;
  if(lr==1)a=(THREE60/2)-a;
  return(a);
}

/*
inline void iv2_divx(iv2 *B,int x,int y)
{
  B->e[0]/=x; 
  B->e[1]/=y; 
}
void iv2_magxy(iv2 *B,int x,int y)
{
  B->e[0]*=x; 
  B->e[1]*=y; 
}
void iv2_setxy(iv2 *B,int x,int y)
{
  B->e[0]=x; 
  B->e[1]=y; 
}
void iv2_add(iv2 *A,iv2 *B)
{
  B->e[0]+=A->e[0];	B->e[1]+=A->e[1]; 
}
*/

void iv2_copy(iv2 *A,iv2 *B)
{
  B->e[0]=A->e[0];	B->e[1]=A->e[1]; 
}
/*	find the equation of a plane from 3 points
	enter 3 point structures( 1*3 matrix )		*/
void planeequation( iv3 *A,iv3 *B,iv3 *C,iv3 *O)
{
  iv3_sub(A,B);
  iv3_sub(A,C);
  O->e[0]=(B->e[1]*(C->e[2]))-(B->e[2]*(C->e[1]));
  O->e[1]=(B->e[0]*(C->e[2]))-(B->e[2]*(C->e[0]));
  O->e[2]=(B->e[0]*(C->e[1]))-(B->e[1]*(C->e[0]));
}

/* finds and expands the boundary box of a point
   call several times for multiple objects */
int iv2_bound(iv2 *A,iv2 *min,iv2 *max)
{
 int x;
  for(x=0;x<2;x++){
    if(A->e[x]>max->e[x])max=A->e[x];
    if(A->e[x]<min->e[x])min=A->e[x];
  }
  return(0);
}
/* checks weather a point is inside a boundary box */
/* inputs: point , lower bound point , upper bboundary */
/* output: zero if not inside 1 if inside */
int iv2_inside(iv2 *A,iv2 *min,iv2 *max)
{
 int x;
  for(x=0;x<2;x++){
    if(A->e[x]>max->e[x])return(0);
    if(A->e[x]<min->e[x])return(0);
  }
  return(1);  /* inside */
}

/* sorts the ab values into min and max */
#define minmax(min,max) if(min>max){ int s=min; min=max; max=s; }
#define clipps(x,min,max) (x>min && x<max)

/*   find the intercept of ab and cd  result in 0 */
/*   return 0 on success , 1 on no intercept. */
int lineintercept(iv2 *A,iv2 *B,iv2 *C,iv2 *D,iv2 *O)
{
  float g1,g2;
  iv2 d1,d2;
  iv2 o1,o2;
  iv2 min,max;
  iv2 min2,max2;

  /* do an x bound check first */

  iv2_copy(A,&min);
  iv2_copy(A,&max);
  iv2_bound(B,&min,&max);  /* line 1 bound */

  iv2_copy(C,&min2);
  iv2_copy(C,&max2);
  iv2_bound(D,&min2,&max2); /* line 2 bound */

  if(iv2_inside(D,&min2,&max2)==0)return(0);
  /* bounds collide ? */
  iv2_setxy(max,0,0);
  iv2_setxy(min,0,0);

  iv2_copy(B,&o1);
  iv2_copy(D,&o2);
  iv2_sub(A,&d1);  /* delta of lines */
  iv2_sub(C,&d2);

  g1=d1.e[0]/d1.e[1];
  g2=d2.e[0]/d2.e[1];

  iv2_sub(A,&o2);  /* point 1 origin point */

  O->e[0]=(B->e[1]*(C->e[2]))-(B->e[2]*(C->e[1]));
  O->e[1]=(B->e[0]*(C->e[2]))-(B->e[2]*(C->e[0]));
  O->e[2]=(B->e[0]*(C->e[1]))-(B->e[1]*(C->e[0]));
 return(1);
}

/*	find the colision point of a plane and a line
	points A & B  are line
	points C,D,E are plane points
	point R is result storage 
	result true if point is on line , -1 if parallel lines */
int planecolision(iv3 *A,iv3 *B,iv3 *C,iv3 *D,iv3 *E,iv3 *R)
{
  float t=0;
  float top=0;
  float bottom=0;
  int res=0;
  planeequation(C,D,E,R);
  iv3_sub(A,B);

  top=(float)R->e[0]*(A->e[0]-C->e[0]);
  top+=(float)R->e[1]*(A->e[1]-C->e[1]);
  top+=(float)R->e[2]*(A->e[2]-C->e[2]);
  bottom=(float)R->e[0]*B->e[0];
  bottom+=(float)R->e[1]*B->e[1];
  bottom+=(float)R->e[2]*B->e[2];
  if(bottom==0)return(-1);
  t=-(top/bottom);

  if((t>=0)&&(t<=1))res=1;
  R->e[0]=(int)(A->e[0]+B->e[0]*t);
  R->e[1]=(int)(A->e[1]+B->e[1]*t);
  R->e[2]=(int)(A->e[2]+B->e[2]*t);
  return(res);
}

/*	find the intersection ipoint of a plane and a line
	ipoints A,B are line equation
	ipoints C,D are plane equation
	ipoint R is result storage
	result true if ipoint is on line , -1 if parallel lines */
int intercept(iv3 *A,iv3 *B,iv3 *C,iv3 *D,iv3 *R)
{
  float t=0;
  float top,bottom;
  int res=0;
  top=(float)D->e[0]*(A->e[0]-C->e[0]);
  top+=(float)D->e[1]*(A->e[1]-C->e[1]);
  top+=(float)D->e[2]*(A->e[2]-C->e[2]);
  bottom=(float)D->e[0]*B->e[0];
  bottom+=(float)D->e[1]*B->e[1];
  bottom+=(float)D->e[2]*B->e[2];
  if(bottom==0)return(-1);
  t=-(top/bottom);
  if((t>=0)&&(t<=1))res=1;
  R->e[0]=(int)(A->e[0]+B->e[0]*t);
  R->e[1]=(int)(A->e[1]+B->e[1]*t);
  R->e[2]=(int)(A->e[2]+B->e[2]*t);
  return(res);
}

/* warning this function exibits error when fed with small values */
/* differential motor drive calculator routine */
/* input: l distance,r distance, wheelbase */
/* output: iv2 q is result, angle is angle rotated */
int ddrive(int l,int r,int base,iv2 *q,int *angle)
{
  int left=0;
  int rev=0;
  if(l<=0 && r<=0){
    l=-l;
    r=-r;
    rev=1;
  }
  if(r>l){
    int swap=l;
    l=r;
    r=swap;
    left=1; 
  }
  if(l==r){   /* straight or stopped */
    q->e[0]=l;
    q->e[1]=0;
    (*angle)=0;
  }else{
    int rad;
    iv2 iq;
    mx22 z;
    rad=r*base;         /* gotta keep em seperated */
    if((l-r)==0){
      rad=0;
      printf("div0 error1\n");
    }else{
      rad=rad/(l-r);
    }
    (*angle)=l*THREE60PIE;
    if((rad+base)==0){
      printf("div0 error2\n");
    }else{
      (*angle)=(*angle)/ (rad+base);     
      /* no floating points required hehe he */
    }
#ifdef DEBUG
    printf("radius =%d ",(rad+base));
    printf("rotation =%d",*angle);
#endif
    iq.e[1]=(rad+(base/2));
    iq.e[0]=0;
    mx22_irotate(&z,*angle);
    mx22_mul(&z,&iq,q);
    q->e[1]-=(rad+(base/2));  /* normalise radial offset */
    q->e[0]=-q->e[0];
  }
  if(rev==1){
    q->e[0]=-q->e[0];
    q->e[1]=-q->e[1];
    *angle= -(*angle);
  }
  if(left==1){
    q->e[1]=-q->e[1];
    *angle= -(*angle); 
  }
  *angle=-(*angle);
  return(rev+(2*left));
}










