 /* Initiger 3D Mathematics routines written by Stephen .T .Humble  */
#include "ll.h"

/* intiger maths structure definitions	*/
#ifndef IMATHS

/* the intiger maths routines use this for sub unit precision operations */  
#define PRECISION 10
#define MULBASE 1024

#define THREE60 1024
/* #define THREE60PIE (THREE60/(2*M_PI)) */
#define THREE60PIE 163

typedef struct{
  int e[3];
}iv3;

	/* designed for use as an x, y ,z point storage matrix	*/
typedef struct{
  float e[3];
}fv3;

	/* designed for use as an x, y point storage matrix	*/
typedef struct{
  int e[2];
}iv2;

typedef struct{
  node nx;
  int color,sides,z;
  int x[12],y[12];
}polygon;

typedef struct{
  int e[9];
}mx33;

typedef struct{
  int e[4];
}mx22;

	/* this structure is used in conjunction with a list of point 
	structures , the corner list below refers to the preceeding 
	point structures and their data */	
typedef struct{
  int cnrs;
  int cnr[6];
  int color,hardness,roughness;
  iv3 grad;
  iv3 xyz;
}surface;

void imaths_init(void);
int isin(int);
int icos(int);
void mx22_mul(mx22 *,iv2 *,iv2 *);
void mx22_rmul(mx22 *,iv2 *,iv2 *);
void mx22_copy(mx22 *,mx22*);
void mx22_print(mx22*);
void mx22_irotate(mx22 *,int x);

int iv2_rotate(iv2 *A,int);
int iv2_mag(iv2*);
int iv2_angle(iv2*);
void iv2_sub(iv2*,iv2*);
void iv2_add(iv2*,iv2*);
void iv2_copy(iv2*,iv2*);
void iv2_print(iv2*);
/*  void iv2_magxy(iv2*,int,int); */
#define iv2_x(v) (v.e[0])
#define iv2_y(v) (v.e[1])
#define iv2_divxy(v,x,y) do{ v.e[0]/=x; v.e[1]/=y; }while(0)
#define iv2_magxy(v,x,y) do{ v.e[0]*=(x); v.e[1]*=(y); }while(0) 
#define iv2_mulxy(v,x,y) do{ v.e[0]*=(x); v.e[1]*=(y); }while(0) 
/*  void iv2_divxy(iv2*,int,int); */
#define iv2_addxy(v,x,y) do{ v.e[0]+=x; v.e[1]+=y; }while(0) 
#define iv2_setxy(v,x,y) do{ v.e[0]=x; v.e[1]=y; }while(0) 
/*  void iv2_divxy(iv2*,int,int); */
/*  void iv2_setxy(iv2*,int,int); */

void mx33_rotatex(mx33*,int);
void mx33_rotatey(mx33*,int);
void mx33_rotatez(mx33*,int);
int mx33_div(mx33 *,fv3*,fv3*);
void mx33_print(mx33*);
void mx33_copy(mx33 *,mx33*);
void mx33_mul(mx33 *,iv3 *,iv3 *);
void mx33_rmul(mx33 *,iv3 *,iv3 *);

void iv3_sub(iv3*,iv3*);
void iv3_add(iv3*,iv3*);
void iv3_copy(iv3*,iv3*);
void iv3_print(iv3*);

int ddrive(int l,int r,int d,iv2 *q,int *angle);

#define IMATHS yes
#endif



























