#include "eyebot.h"
#include "irq.h"

#include <assert.h>

/* The default irq handler, defined in exhandle.s */
static int notinst = 0;

/*
 * Return the content of the current interrupt vector.  Currently
 * zero.  The correct way is to check the %vbr register, but I did not
 * manage to get GCC to understand my inline assembly.
 */
void *get_current_vector_base(void)
{
  register void *vector_base __asm("%d0") = 0;
  /* __asm("movec %vbr, %d0" : "=r" (vector_base) : : ); */
  return vector_base;
}

int
request_irq(unsigned int irq,
	    void (*handler)(int, void *, struct pt_regs *),
	    unsigned long flags,
	    const char *device,
	    void *dev_id)
{
  int *vector_base = get_current_vector_base();
  assert(sizeof(int) == sizeof(void*));

  /* User programs need to reset this when they start!  I just pick
     200, and hope this interrupt havent been set yet. :-) */
  if (0 == notinst)
    notinst = *(vector_base+200);

  LCDPrintf("RIRQ: (%d)\n%d %d %d\n", irq, notinst, vector_base, *(vector_base+irq));
  KEYWait(ANYKEY);

  if ((int)notinst != *(vector_base+irq))
    return -1; /* Interrupt busy, deny access */

  *(vector_base+irq) = (int)handler;

  return 0;
}

void
free_irq(unsigned int irq, void *dev_id)
{
  int *vector_base = get_current_vector_base();
  *(vector_base+irq) = (int)notinst;
}
