/*  Filename: kays.c
   Author :Stephen Humble
   Description:  keyboard input for eyebot controll
*/
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#ifndef INTEL
#include "vision-system.h"
#include "eyebot.h"
#define CLS LCDClear();
#else
#include "robot.h"
#define CLS printf("cls\n");
#endif
#include "language.h"
#include "imagination.h"
#include "drive-main.h"
#include "compass.h"
#include "imaths.h"
#include "keys.h"

/* root menue structure */ 
struct menue root;

/* initialise root menue structure */ 
int key_init()
{
  struct menue *Z,*Q;
  Z=&root;
  Z->next=NULL;
  Z->prev=NULL;
  Z->doit=main_menue; /* initialize */
  return(0);
}

/*  calls the selected menue routine */
int key_menue()
{
  struct menue *Z;
  Z=&root;
  while(Z->next!=NULL)Z=Z->next;
  int v=Z->doit();
  if(v==-1){
    Z=Z->prev;
    if(Z==NULL)return(-1); /* exit signal */
    free(Z->next);
    Z->next=NULL;
    return(0);
  }
  return(0);
} 

/* allocate a node and add new submenue */
int select(int (*doit)(void))
{
  struct menue *Z,*Q;
  Z=(menue *)malloc(sizeof(menue));
  Z->doit=doit;
  Z->next=NULL;
  Q=&root;
  while(Q->next!=NULL)Q=Q->next;
  Q->next=Z;
  Z->prev=Q;
  return(0);
}

/* return a character -1 for escape 0 for nothing */
char getch()
{
  static int s=0;
  static int cnt=10;
  int k=0;
#ifndef INTEL
  k=KEYRead();
  if(q==KEY1)s++;
  if(q==KEY2)s--;
  printf("SELECT %d",s);
  if(q==KEY3){
    return(s+'1');
  }
  if(q==KEY4){
    return(-1);
  }
#else
  if(cnt-- <0){
    printf("enter selection\n");
    k=getchar();
    if(k=='x' || k=='q')return(-1);
    if(k=='c' || k==' '){
      cnt=10000;
      return(0);
    }
    return(k);
  }
#endif
  return(0);
}

int main_menue()
{
  static int ud=1; 
  int c; 
  if(ud==1){
  printf("select menue\
\n0=Tracks\
\n1=drive on-off\
\n2=compass\
\n3=command\
\n4=errorlog");
  ud=0;
  }
  c=getch();
  if(c!=0)ud=1;
  if(c==-1)return(-1); /* exit */
  switch(c){
  case '1':
    select(key_tracks);  /* sub menue routine */
    break;   
  case '2':
    select(key_drive);  /* handling routine */
    break;   
  case '3':
    /* select(key_compass);*/  /* handling routine */
    break;   
  case '4':
    /* select(key_cmd); */
    break;   
  default:
    break;
  }
  return(0);
}

/* eyebot keyboard input and
   mind display controll interface */
int key_tracks()
{
  static int view=0;
  track *ob;
  char c;
  int x;
  printf("tracks \n");
    track *Z=track_gethead();
    for(x=0;x<view;x++){
      if(Z->next==NULL){
	view=0;
	Z=track_gethead();
	break;
      }
      Z=Z->next;
    }
    track_print(Z);
    
  c=getch();
  if(c==-1)return(-1);
  if(c!=0)view=c-'1';
  return(0);
}
  /* real time text menue system */
 
int key_drive()
{  /* handling routine */
  static int ud=1; 
  char c; 
  if(ud==1){
  printf("select menue /
\n0=drive off/
\n1=drive on");
  ud=0;
  }
  c=getch();
  if(c!=0)ud=1;
  if(c==-1)return(-1);
  if(c=='1'){
    drive_on();
return(-1);
  }
  if(c=='2'){
    drive_off();
return(-1);
  }
return(0);
}







































