/****** robot control language listening and talking routines 
written for robocup 2000 by S.Humble - additions by ???
*****************************************************************************/
/* robot radio control language interpreter */
#include <stdio.h>
#include "language.h"
#include "imagination.h"
#ifndef INTEL
#include "vision-system.h"
#include "eyebot.h"
#else
#include "robot.h"
#endif

int comms_init()
{
  if(RADIOInit()==0)printf("comms ready");
  return(0);
}

/* Return strings for character codes */
/* returns english language strings translations of character codes */ 
char *trans_code(char code)
{
  switch(code){
  case cLANFriend: return("Friend");
  case cLANEnemy: return("Enemy");
  case cLANSpin: return("Spin or Wave");
  case cLANWait: return("Wait");
  case cLANStart: return("Start");
  case cLANMove: return("Move");
  case cLANAvoid: return("Avoid");
  case cLANKick: return("Kick");
  case cLANFollow: return("Follow");
  case cLANBlock: return("Block");
  case cLANPush: return("Push");
  case cLANIntercept: return("Intercept");
  case cLANDeflect: return("Deflect");
  case cLANLearnPath: return("Learn Path");
  case cLANDrivePath: return("Drive Path");
  case cLANBackup: return("Backup");
  case cLANCalibrate: return("Calibrate Sensors");
  case cLANExplore: return("Explore");
  case cLANNow: return("Now");
  case cLANNext: return("Next");
  case cLANAllways: return("Allways");
  case cLANCancel: return("Cancel");
  case cLANText: return("Display Text");
  case cLANBall: return("Ball");
    /* all names below are for zones */ 
  case cLANGoal: return("Goal");
  case cLANGoalZone: return("GoalZone");
  case cLANHome: return("HomeGoal");
  case cLANHomeZone: return("HomeGoalZone");
  case cLANPlayPosition: return("PlayPosition");
  case cLANCursor: return("Cursor");
  case cLANField: return("Field");
  case cLANOrigin: return("Center");
  case 0: return("ZERO");
  default:
    return("?");
  }
  return("weird error");
}

/*  radio decoder routine - robot processes messages */
int listen()
{
  int s;
  int q=0;
  unsigned char sender; 
  char msg[250];
  if(RADIOCheck()==0)return(0);
  /*
  RADIORecv(&sender,&s,(unsigned char *)msg);
  while(q<s){
    switch(msg[q]){

    case cLANTrack:
      track_advise((sLANTrack *)&msg[q]);
      break;

    case cLANText:      {
      sLANText *Z=(sLANText *)&msg[q];
      if(Z->file==cLANPrint)printf(&Z->data);
    }
    break;

    case cLANCommand:
      command_add((sLANCommand *)&msg[q]);
      break;
    default:
      break;
    }
    q+=msg[q+1]; 
  }
  */
 /* jump to next message */

  return(0);
}

/* routine for a robot to tell another robot about a position Track */
/*  usage example of how to tell robot 1 location and direction of ball  */
/*  location(1,cLANBall,50,90,20,270); */  
int location_send(char robot,int x,int y,int v, int angle){
  sLANTrack H;
  H.type=cLANTrack;
  H.size=sizeof(sLANTrack);
  H.name=cLANBall;
  H.x=x;
  H.y=y;
  H.v=v;
  H.a=angle;
  RADIOSend(robot,H.size,(BYTE *)&H);
  return(1);
}

/*  routine to send message commands to a robot */
/*  usage example of how to make robot 2 ram the ball at the Goals -  */
/*  command(BROADCAST,cLANRam,cnLANBall,cnLANGoal);  */
int command_send(char robot,char command,char name,char num,char name2,char num2){
  sLANCommand H;
  H.type=cLANCommand;
  H.size=sizeof(sLANCommand);;
  H.cmd=command;

  H.name=name;
  H.num=num;

  H.name2=name2;
  H.num2=num2;

  RADIOSend(robot,H.size,(BYTE *)&H);
  return(1);
}





















































