/****** robot control language
written for robocup 2000 by S.Humble - additions by ???
This file defines a simple but effective and flexible standard for inter robot
and Master control Program MCP communications.
The first byte of any RADIO messsage defines the message type ,
the second byte is the size.
this file also contins several message types for robot soccer or other mobile
robot applications they are reasonably concise and space efficient as well
as proccssor efficient for the cpu to process.
Unit for length used is mili meters - it's resolution and range are ideal 
for mobile robotics.
Velocity is in mm per second.
Angles increment anticlockwise, angle units in a circle
are defined with CIRCLE.  ie CIRCLE = 2PIE * C
16 bit intiger word's are used for all velocitys , distances and angle's.
*****************************************************************************/
#ifndef LANGUAGE
#define CIRCLE 1024

int listen(void); /* this is the routine used to read radio messages */
int comms_init(); /* initailise communication ststem */
char *trans_code(char);  /* Return string translation of character codes */
/*  byte code for Track messages */
/*  Track messages are used to describe position and velocity of an  */
/*  object(ball robot etc)- x,y are in mili meters  */
#define cLANTrack 't'
/* struct sLANTrack.type=cLANTrack and size = sizeof(struct sLANTrack)*/
/*  for 68000 compatability ive made all the structures word alligned */
/*  Track is used to tell a x,y position and v=velocity of movement */
/*  a is direction in degrees */
/*  name is the description of the object ie cLANBall ,cLANRobot,cLANGoal.*/
/*  num is a sub idenfifier usefull where there is .>1 instance of an object */
typedef struct{
  char type,size;
  char name,num;
  short int x,y;
  short int v,a;
} sLANTrack;

/*  Code for Raw data and Text string transfers used to print messages,log */
/*  error messages on the MCP or display messages on the eyebot display. */
#define cLANText 'd'
/*  Raw data & Text header the user appends data and sets size. */
typedef struct {
  char type,size,file,data;
}sLANText;
/* sLANText->file describes what to do with the text */
#define cLANPrint 0
#define cLANError 1
#define cLANLog 2

/*  Code for Time. - used to include a time code with messages. */
/*  (may not be required */
/*  Time is measured in 1/100 of a second - in a 32 bit word */
#define cLANTime 'T'
typedef struct {
  char type,size;
  int time;
}sLANTime;

/* sLANText->file describes what to do with the text
#define cLANPrint 0
#define cLANError 1
#define cLANLog 2
*/
/*  Definitions of name codes to be used in Track and Command messages */
/*  if there are multiple units of the same object the */
/*  objects are numbered using the number byte */
/*  cnLANCursor is an imaginary location which can for example */
/*  be used by the move command - usefull for experimentation */
/*  and as a simple robot control method */ 
#define cLANFriend 'F'
#define cLANEnemy 'E'
#define cLANBall 'O'
/* all names below are for zones */ 
#define cLANGoal 'G'
#define cLANGoalZone 'g'
#define cLANHome 'H'
#define cLANHomeZone 'h'
#define cLANPlayPosition 'p'
#define cLANCursor 'x'
#define cLANField 'f'
#define cLANOrigin '0'

/* names below are for track classification type */
#define cLANZone 'z'
#define cLANAlive 'A'

/* type code for sLANCommand message's */
#define cLANCommand 'C'
/* sLANCommand is the structure used to contain a command */ 
typedef struct {
  char type,size;
  char cmd,pri;
  char name,num;
  char name2,num2;
}sLANCommand;

/*  codes for sLANCommand->cmd */
/*  Spin and Wave are used to identify a robot whose location is not known */
/*  Wait ,Start and Move are used to enable us to comply with robocup ruels */
/*  for kickoff and penalty shots */
/*  Avoid ,Kick , Follow , Push,Intercept and Deflect are high level  */
/*  commands for smart robots with some on board intelligence, */
/*  2 names are given for each command so that a robot could for example */
/*  be told to Block an enemy robot from the Ball, Intercept a Ball, */
/*  Follow a team member, Kick a ball at an enemy, */
/*  deflect the ball at the goals, Avoid an area of the field,  */
/*  or many other possibilities */
#define cLANSpin 'S'
#define cLANWait 'W'
#define cLANStart 's'
#define cLANMove 'M'
#define cLANAvoid 'A'
#define cLANKick 'K'
#define cLANFollow 'a'
#define cLANBlock 'B'
#define cLANPush 'P'
#define cLANIntercept 'I'
#define cLANDeflect 'D'
/* commands below are some other robot commands */
#define cLANLearnPath 'L'
#define cLANDrivePath 'R'
#define cLANBackup 'b'
#define cLANCalibrate 'c'
#define cLANExplore 'e'
#define cLANBeserk 'K'

/*  codes for sLANCommand->pri command modifier code - */
/*  used to specify how to treat a command -  */
/*  commands can be qued , executed immediatlly , or added to a list of */
/*  directives. */
/*  For example you could tell a robot to Allways move inside a goal */
/*  zone, Spin arround Now, kick a ball then move to a location. */
#define cLANNow 'N'
#define cLANNext 'n'
#define cLANAllways 'Z'
#define cLANCancel 'C'

/*  codes below are used to indicate various messages which tell robot */
/*  about it's environment - probably only need to be called once or */
/*  twice per game walls, zones on the field , - all of these are name */
/*  based , these routines allow us to provide robots with additional */
/*  information about the soccer field */
/*  not yet complete !!!!! */
#define cLANColor 'c'
#define cLANPoint 'p'
#define cLANIcon 'i'
#define cLANWall 'l'
#define cLANZone 'z'
#define cLANEnd 'e'

/* this is used to tell robots the color of following items being described */ 
/*  struct sLANColor{ */
/*    char type,size; */
/*    unsigned char red,green,blue; */
/*  } */

#define LANGUAGE yes
#endif
















