 /* FUN */
 /* visual system written by stephen .t .humble*/
/* various clipping routines */
#include "maths.h"
#include <stdio.h>
#include <string.h>

 /* size of screen to clip to */
#define ClipX 320
#define ClipY 180

 /* find outcodes of a point  */
int outcodes(x1,y1)
int x1,y1;
{
int out=0;
 if(x1<0)out=1;
 if(x1>=ClipX)out+=2;
 if(y1<0)out+=8;
 if(y1>=ClipY)out+=4;
 return(out);
}

 /*	 test borders	*/

int outtop(y1)
int y1;
{
int out=0;
 if(y1<0)out=1;
 return(out);
}
int outleft(x1)
int x1;
{
int out=0;
 if(x1<0)out=1;
 return(out);
}
int outright(x1)
int x1;
{
int out=0;
 if(x1>=ClipX)out=1;
 return(out);
}
int outbottom(y1)
int y1;
{
int out=0;
 if(y1>=ClipY)out=1;
 return(out);
}

 /*	oddx,oddxy is a list of the corner points of the polygon 
	  the last point is the same as the first point  
	size is the number of sides triangle =3 polygon = 4 
	newx,newy is the destination							 */
clippolygon(oddx,oddy,sides,newx,newy)
int *oddx,*oddy,*newx,*newy;
int sides;
{
int x1,y1,x2,y2;
int sc,nsc;
int last;

FLOAT gradx=0;
FLOAT grady=0;
int out1=0;
int out2=0;
					/* clip left side of window */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
		x2=oddx[sc];	y2=oddy[sc];
		x1=oddx[last];	y1=oddy[last];
		last=sc;
		out1=outleft(x1);
		out2=outleft(x2);
	if((out1 & out2) != 0 )continue;
	if(x1==x2&&y1==y2)continue;
	if( out1==0 && out2 == 0 ){
		newx[nsc]=x2;	newy[nsc]=y2;		
		nsc++;
		continue;
		};
	grady=( (float)(y1-y2) / (float)(x2-x1) );
	if(out2 !=0){
		y1+=(grady*x1);
		x1=0;
		newx[nsc]=x1;	newy[nsc]=y1;
		nsc++;
		continue;
		};
	if(out1  !=0){
		y1+=(grady*x1);
		x1=0;
		newx[nsc]=x1;	newy[nsc]=y1;
		nsc++;
		newx[nsc]=x2;	newy[nsc]=y2;
		nsc++;
		};
		}
	sides=nsc;
	if(sides<3)return(0);
	for(sc=0;sc<sides;sc++){
		oddx[sc]=newx[sc];	oddy[sc]=newy[sc];
	}
					/* clip top side of window */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
			x2=oddx[sc];	y2=oddy[sc];
			x1=oddx[last];	y1=oddy[last];
			last=sc;
			out1=outtop(y1);	out2=outtop(y2);
		if((out1 & out2) != 0 )continue;
		if(x1==x2&&y1==y2)continue;
		if( out1==0 && out2 == 0 ){
			newx[nsc]=x2;	newy[nsc]=y2;
			nsc++;
			continue;
			};
		gradx=( (float)(x1-x2) / (float)(y2-y1) );
		if(out2 !=0){
			x1+=(gradx*y1);
			y1=0;
			newx[nsc]=x1;	newy[nsc]=y1;
			nsc++;
			continue;
			};
		if(out1  !=0){
			x1+=(gradx*y1);
			y1=0;
			newx[nsc]=x1;	newy[nsc]=y1;
			nsc++;
			newx[nsc]=x2;	newy[nsc]=y2;
			nsc++;
			};
		}
	sides=nsc;
	if(sides<3)return(0);
	for(sc=0;sc<sides;sc++){
		oddx[sc]=newx[sc];		oddy[sc]=newy[sc];
	}
					/* clip right side of window */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
			x2=oddx[sc];	y2=oddy[sc];
			x1=oddx[last];	y1=oddy[last];
			last=sc;
			out1=outright(x1);	out2=outright(x2);
		if((out1 & out2) != 0 )continue;
		if(x1==x2&&y1==y2)continue;
		if( out1==0 && out2 == 0 ){
			newx[nsc]=x2;	newy[nsc]=y2;
			nsc++;
			continue;
			};
		grady=( (float)(y1-y2) / (float)(x2-x1) );
		if(out2 !=0){
			y1+=(grady*(x1-ClipX));
			x1=ClipX-1;
			newx[nsc]=x1;	newy[nsc]=y1;
			nsc++;
			continue;
			};
		if(out1  !=0){
			y1+=(grady*(x1-ClipX));
			x1=ClipX-1;
			newx[nsc]=x1;	newy[nsc]=y1;
			nsc++;
			newx[nsc]=x2;	newy[nsc]=y2;
			nsc++;
			};
		}
	sides=nsc;
	if(sides<3)return(0);
	for(sc=0;sc<sides;sc++){
		oddx[sc]=newx[sc];	oddy[sc]=newy[sc];
	}
					/* clip bottom side of window */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
		x2=oddx[sc];	y2=oddy[sc];
		x1=oddx[last];	y1=oddy[last];
		last=sc;
		out1=outbottom(y1);
		out2=outbottom(y2);
	if((out1 & out2) != 0 )continue;
	if(x1==x2&&y1==y2)continue;
	if( out1==0 && out2 == 0 ){
		newx[nsc]=x2;	newy[nsc]=y2;
		nsc++;
		continue;
		};
	gradx=( (float)(x1-x2) / (float)(y2-y1) );
	if(out2 !=0){
		x1+=(gradx*(y1-ClipY));
		y1=ClipY-1;
		newx[nsc]=x1;	newy[nsc]=y1;
		nsc++;
		continue;
		};
	if(out1  !=0){
		x1+=(gradx*(y1-ClipY));
		y1=ClipY-1;
		newx[nsc]=x1;	newy[nsc]=y1;
		nsc++;
		newx[nsc]=x2;	newy[nsc]=y2;
		nsc++;
		};
		}
	sides=nsc;
	if(sides<3)return(0);
	for(sc=0;sc<sides;sc++){
		oddx[sc]=newx[sc];		oddy[sc]=newy[sc];
	}
		/* remove sides that are fucked length */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
		x2=oddx[sc];	y2=oddy[sc];
		x1=oddx[last];	y1=oddy[last];
		last=sc;
		out1=outcodes(x1,y1);
		out2=outcodes(x2,y2);
	if((out1 & out2) != 0 )continue;
	if(x1==x2&&y1==y2)continue;
	if( out1==0 && out2 == 0 ){
		newx[nsc]=x2;	newy[nsc]=y2;
		nsc++;
		continue;
		};
	}
	sides=nsc;
	if(sides<3)return(0);
	return(sides);
}

/* determin weather the point is inside the polygon *
 * result inside = 1  outside = 0  */
int inside(A,pgon)
struct pos *A;
struct polygon *pgon;
{
FLOAT gradx=0;
int x1,y1,x2,y2;
int xlist[10];
int xnum=0;
int sc,last;
int cross=-1;
	last=(pgon->sides)-1;
	for(sc=0;sc<pgon->sides;sc++){
		x2=pgon->x[sc];			y2=pgon->y[sc];
		x1=pgon->x[last];		y1=pgon->y[last];
		last=sc;
		if((y1<=A->e[1])&&(A->e[1]<y2)){
			gradx=( (float)(x1-x2) / (float)(y2-y1) );
			xlist[xnum]=x1-(gradx*(A->e[1]-y1));
			xnum++;
			continue;
		};
		if((y2<A->e[1])&&(A->e[1]<=y1)){
			gradx=( (float)(x1-x2) / (float)(y2-y1) );
			xlist[xnum]=x1+(gradx*(y1-A->e[1]));
			xnum++;
			continue;
		};
		if((y2==A->e[1])&&(A->e[1]==y1)){
			if(x1==x2){
				xlist[xnum]=x1;
				xnum++;
				}
			else {
				xlist[xnum]=x1;
				xnum++;
				xlist[xnum]=x2;
				xnum++;
				};
			continue;
		};
	}
	for(sc=0;sc<xnum;sc++){
		if(xlist[sc]>A->e[0])cross=-cross;
		if(xlist[sc]==A->e[0]){
			cross=1;
			break;
			};	
	}
	if(cross==1)return(1);
	return(0);
}

	/* test weather num2 is between num1 and num3  */
int between(num1,num2,num3)
int num1,num2,num3;
{
	if((num1<num2)&&num2<num3)return(1);
	if((num3<num2)&&num2<num1)return(1);
	return(0);
}	

/* polygons are tested to see weather the first polygon is fully enclosed
 * by the second one and does therefor not need to be drawn.
 * true if polygon1 is inside polygon2		*/
insidepolygon(poly1,poly2)
struct polygon *poly1,*poly2;
{
struct pos A;
int ct;
	for(ct=0;ct<poly1->sides;ct++){
		A.e[0]=poly1->x[ct];
		A.e[1]=poly1->y[ct];
		if(inside(&A,poly2)==0)return(0);
	}
	return(1);
}

/* clip the coordinates to borders	*
 * if out of bounds clip line 		*/
clipline(A,B)
struct pos *A,*B;
{
FLOAT gradx=0;
FLOAT grady=0;
int out1=0;
int out2=0;
	if(A->e[0]==B->e[0]&&A->e[1]==B->e[1])return(0);
	out1=outcodes(A->e[0],A->e[1]);
	out2=outcodes(B->e[0],B->e[1]);

	if((out1 & out2) != 0 )return(0);
	if( out1==0 && out2 == 0 )return(1);
	if(((out1 | out2) & 12) !=0)gradx=( (float)(A->e[0]-B->e[0]) / (float)(B->e[1]-A->e[1]));
	if(((out1 | out2) & 3) !=0) grady=( (float)(A->e[1]-B->e[1]) / (float)(B->e[0]-A->e[0]));

	if((out1 & 1) !=0){
	A->e[1]+=(grady*A->e[0]);
	A->e[0]=0;
	};
	if((out1 & 2) !=0){
	A->e[1]+=(grady*(A->e[0]-ClipX));
	A->e[0]=ClipX-1;
	};

	out1=outcodes(A->e[0],A->e[1]);

	if((out1 & 8) !=0){
	A->e[0]+=(gradx*A->e[1]);
	A->e[1]=0;
	};
	if((out1 & 4) !=0){
	A->e[0]+=(gradx*(A->e[1]-ClipY));
	A->e[1]=ClipY-1;
	};
	if((out2 & 1) !=0){
	B->e[1]+=(grady*B->e[0]);
	B->e[0]=0;
	};
	if((out2 & 2) !=0){
	B->e[1]+=(grady*(B->e[0]-ClipX));
	B->e[0]=ClipX-1;
	};

	out2=outcodes(B->e[0],B->e[1]);

	if((out2 & 8) !=0){
	B->e[0]+=(gradx*B->e[1]);
	B->e[1]=0;
	};
	if((out2 & 4) !=0){
	B->e[0]+=(gradx*(B->e[1]-ClipY));
	B->e[1]=ClipY-1;
	};
	return(1);
}
#define ZZERO 40

int outz(z1)
int z1;
{
int out=0;
 if(z1<ZZERO)out=1;
 return(out);
}

int zclipline(A,B)
struct iv3 *A,*B;
{
struct iv3 line1,line2;
FLOAT t;
int out1=0;
int out2=0;
					/* clip line to positive space coords */
	out1=outz(A->e[2]);
	out2=outz(B->e[2]);
	if((out1 & out2) != 0 )return(0);
	if(A->e[2]==B->e[2]&&A->e[0]==B->e[0]&&A->e[1]==B->e[1])return(0);
	if( out1==0 && out2 == 0 ){
		return(1);
		};
	if(out2){
		iv3_copy(A,&line1);
		iv3_copy(B,&line2);
		iv3_sub(&line1,&line2);
		t=(float)(ZZERO-A->e[2])/(float)(B->e[2]-A->e[2]);
		B->e[0]=line1.e[0]+line2.e[0]*t;
		B->e[1]=line1.e[1]+line2.e[1]*t;
		B->e[2]=ZZERO;
		return(1);
		};
	if(out1){
		iv3_copy(A,&line1);
		iv3_copy(B,&line2);
		iv3_sub(&line1,&line2);
		t=(float)(ZZERO-A->e[2])/(float)(B->e[2]-A->e[2]);
		A->e[0]=line1.e[0]+line2.e[0]*t;
		A->e[1]=line1.e[1]+line2.e[1]*t;
		A->e[2]=ZZERO;
		return(1);
		};
 return(1);
}

int zclip(pnt1,sides,pnt2)
int sides;
struct iv3 *pnt1,*pnt2;
{
int x1,y1,x2,y2;
int z1,z2;
int sc,nsc;
int last;

FLOAT gradx=0;
FLOAT grady=0;
int out1=0;
int out2=0;
					/* clip left side of window */
	last=sides-1;
	nsc=0;
	for(sc=0;sc<sides;sc++){
		x2=pnt1[sc].e[0];		y2=pnt1[sc].e[1];		z2=pnt1[sc].e[2];

		x1=pnt1[last].e[0];	y1=pnt1[last].e[1];	z1=pnt1[last].e[2];

		last=sc;
		out1=outz(z1);
		out2=outz(z2);
	if((out1 & out2) != 0 )continue;
	if(z1==z2&&x1==x2&&y1==y2)continue;
	if( out1==0 && out2 == 0 ){
		pnt2[nsc].e[0]=x2;	pnt2[nsc].e[1]=y2;	pnt2[nsc].e[2]=z2;		
		nsc++;
		continue;
		};
	gradx=( (float)(x1-x2) / (float)(z2-z1) );
	grady=( (float)(y1-y2) / (float)(z2-z1) );
	if(out2 !=0){
		y1+=(grady*(z1-ZZERO));
		x1+=(gradx*(z1-ZZERO));
		z1=ZZERO;
		pnt2[nsc].e[0]=x1;	pnt2[nsc].e[1]=y1;	pnt2[nsc].e[2]=z1;		
		nsc++;
		continue;
		};
	if(out1  !=0){
		y1+=(grady*(z1-ZZERO));
		x1+=(gradx*(z1-ZZERO));
		z1=ZZERO;
		pnt2[nsc].e[0]=x1;	pnt2[nsc].e[1]=y1;	pnt2[nsc].e[2]=z1;		
		nsc++;
		pnt2[nsc].e[0]=x2;	pnt2[nsc].e[1]=y2;	pnt2[nsc].e[2]=z2;
		nsc++;
		};
		}
	sides=nsc;
	if(sides<3)return(-1);
 return(sides);
}
