#include <stdio.h>
#ifdef INTEL
typedef int QuadHandle;
#include "robot.h"
#else
#include "eyebot.h"
#endif
#include "quad.h"

#define LIMIT 450
int quad_read(struct _quad *Z){
  int dx;
  int dt;
  int t;
  t=OSGetCount();
  dt=t-Z->time;
  if(dt<6){ /* only update 20 times per second max */
    return(0); /* no counts recorded this soon */
  }
  Z->time=t;
#ifndef INTEL
  int q=QUADRead(Z->handle);  /* record distances moved */
  dx= q - Z->last;
  /* need to add in counter wrap compensation  */
  Z->last=q;
  Z->cps=dx*100/dt;
#else
  Z->last+=(Z->sim*dt)/100;  /* inertia */
  Z->last-=(dt*Z->last/700);  /* friction */
  if(Z->last>LIMIT)Z->last=LIMIT;  /* limiter */
  if(Z->last<-LIMIT)Z->last=-LIMIT;
  dx=Z->last;
  Z->cps=dx*100/dt;
#endif
  return((dx*dt)/100);
}

int quad_init(struct _quad *Z,int id,int motor_id){
#ifndef INTEL
  Z->handle = QUADInit(id);
  printf("quad %d\n",(int)Z->handle);
  Z->last=QUADRead(Z->handle);

  Z->motor=MOTORInit(motor_id);
  if(!Z->motor) 
    {
      printf("Init Error!\n");
      getchar();
      return(0);
    }
#endif

  return(Z->handle);
}

int quad_cps(struct _quad *Z){
  return(Z->cps);
}

int quad_drive(quad *Z,int s)
{
#ifndef INTEL
  MOTORDrive(Z->motor,s);
#else
  /* simulated inertia drive */
  Z->sim=s;
#endif
  return(0);
}




