/* quadrature decoder object */
#ifndef QUADRATURE

#ifdef INTEL
typedef int QuadHandle;
#define QUADRead(a) abs(a)
#else
#include "eyebot.h"
#endif

typedef struct _quad{
 QuadHandle handle;
 int time; /* last read time   */ 
 int cps; /* counts per second*/
 int last;
 int motor;
  int sim;  /* simulator */
 int (*read)(struct _quad*);
}quad;

int quad_init(struct _quad *Z,int id,int motor_id);
int quad_read(struct _quad *Z);
int quad_cps(struct _quad *Z);
int quad_drive(struct _quad *,int s);
#define  QUADRATURE yes
#endif
