/** @name serial_communications.h 

    This is the main include file for the serial communications protocol.

    @author Daniel Storey, UWA, 1998
    @version 1.0   */

/*@{*/

/** Enables debuging messages if non-zero */
#define DEBUG 0
/** Displays serial I/O if active */
#define VIEW_SERIAL_DATA 0
/** Displays Token Messages and Timeouts */
#define TOKEN_MSG 0
/** Displays when Timer functions are called */
#define TIMERS 0
/** Sends serial data to another PC fopr monitoring */
#define PC_SERIAL_CHECK 0

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "librobi/librobi.h"
#include "librobi/protos.h"
#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "kern.h"

/** number of FFh bytes in the preamble that is sent before transmissions */
#define PREAMBLE_BYTES 50
/** number of 55h bytes in the preamble after the FFh bytes */
#define LOCK_BYTES 5
/** number of FFh bytes in the preamble after the 55h bytes */
#define AFTER_BYTES 10
/** Length of input and output RS232 Buffers */
#define BUFFER_LENGTH 2000
/** number of outgoing packets that can be queued */
#define QUEUE_ELEMENTS 6
/** number of outgoing special packets that can be queued */
#define SPECIAL_QUEUE_ELEMENTS 2*QUEUE_ELEMENTS
/** number of incoming string packets that can be queued (should be same as SPECIAL_QUEUE_ELEMENTS) */ 
#define STRING_QUEUE_ELEMENTS 2*QUEUE_ELEMENTS
/** maximum number of received frames that can be monitored for duplicates */
#define RECENT_FRAME_QUEUE_ELEMENTS 10
/** maximum number of token passes before discarding old received frames (max 100, typical 10) */
#define MAXIMUM_RECEIVED_FRAME_AGE 10
/** maximum data length a packet can contain (Absolute Max = 6e3) */
#define MAXIMUM_DATA_LENGTH 200
/** maximum total length of packet */
#define MAXIMUM_TOTAL_PACKET_LENGTH (MAXIMUM_DATA_LENGTH + 20)
/** maximum delay between transmissiond before a token is regenerated */
#define MAX_TIMEOUT_DELAY 100
/** Number of Dummy Chars sent after a transmission */
#define DUMMY_CHARS 10
/** Length of time between executions of the timer routine */
#define CYCLE_TIME 2

/** length of the packet address field */
#define ADDRESS_LEN 1
/** length of the packet type field (not changeable)*/
#define PACKET_TYPE_BYTES 2
/** length of the packet crc field (not changeable*/
#define CRC_BYTES 8

#include "structure_definitions.h"
#include "function_definitions.h"

/** packet start indicator */
#define PACKET_START '!'
/** packet end indicator */
#define PACKET_END   '#'

/** boolean true */
#define TRUE 1
/** boolean false */
#define FALSE 0

/** maximum number of times to resend a packet before it is queued as an error */
#define MAXIMUM_NUMBER_OF_RESENDS 5

/** coding indicator for a special character */
#define COMMS_STRING_SPECIAL_CHARACTER_INDICATOR '/'

/* Special Packet Types and Associated Lengths
 *
 * R (Reply) Packet OK
 * ? (Reply) Resend Packet */
/** special packet type indicator */
#define SPECIAL_PACKET_SYMBOLS {'R',  'T'}
/** lengths of the associated special packets */
#define SPECIAL_PACKET_LENGTHS { 0,    0 }
/** number of special packet types */
#define NUMBER_OF_PACKET_SYMBOLS 2 /* Number of packet types */
/** symbol used to declare a special packet */
#define SPECIAL_PACKET_START_SYMBOL '$'

/** Eyebot serial port */
#define EYEBOT_SERIAL_PORT SERIAL2

/** Serial Speed Definitions */
#define SER9600         0
#define SER19200        1
#define SER38400        2
#define SER57600        3
#define SER115200       4
















