/***********************************************************************/
/** @name global.h   
    Contains all global definitions and variables.

    @author Thomas Braunl & Birgit Graf, UWA, 1998
*/
/***********************************************************************/

/*@{*/

#include "eyebot.h"

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


/* -----------= directions =-------------- */

#ifndef RIGHT
#define RIGHT 1
#endif

#ifndef LEFT
#define LEFT -1
#endif

#define MIDDLE 0
#define FRONT 0			/* for PSD */

#define UP 1			/* for camera servo */
#define DOWN 2



/* -----------= constant factors =-------------- */

#ifndef PI
#define PI 3.1415926535
#endif
#define PI2 1.5707963		/* PI half */

#define SSIZE 8192		/* stack for parallel processing */

#define LENGTH 2.740		/* field length (in m) */
#define LENGTH2 1.370		/* field length (in m) */
#define LENGTH4 0.685		/* quarter field length (in m) */
#define WIDTH2 0.7625		/* half field width (in m) */
#define WIDTH4 0.38125		/* quarter field width (in m) */

#define GOALWIDTH 0.5		/* goal width (in m) */
#define ROBWIDTH2 0.04		/* half robot width (in m) */


/* -----------= colours =-------------- */

#define BLACK  0
#define WHITE 15


/* -----------= player positions =-------------- */

#define POS_G  1
#define POS_LB 2
#define POS_RB 3
#define POS_LF 4
#define POS_RF 5


/* -----------= speeds =-------------- */

extern meterPerSec LIN_SPEED;
extern radPerSec ROT_SPEED;


/* -----------= tables =--------------  */

/** factor to calculate y position from pixels to meters depending on
    x position (achieved by getting width in m of object that has
    width of screen at selected y positions, fact = val(m)/imagerows)
*/
extern float yfact[3][imagerows];

/** get x position in meters from x position in pixels */
extern float x2m[3][imagerows];

/** ball distance in meters depending on x and y position in pixels */
extern float ball_dist[3][imagerows / 2][imagecolumns];


/** Handle for motors */
extern VWHandle vw;
/** flag to detect whether motors are used or test mode without motors */
extern int use_motors;		


/* -----------= global flags =-------------- */
/** flag to indicate current camera position (UP or DOWN), set after
    camera movement */
extern int cam_pos;


/* ----= flags to indicate results of sensor readings  =---- */
/** flag to indicate keypress (-> end ball search) */
extern int end_flag;

/** flag to indicate detected object */
extern int obstacle_flag;

/** flag to indicate having ball caught in front of robot */
extern int got_ball_flag;

/** flag to indicate seeing ball */
extern int see_ball_flag;	

/** flag to indicate that program just started */
extern int start_flag;
extern int start_flag1;
extern int attack_flag ;

/** flag for competition mode */
extern int competition_mode;		
  
/** position of player */
extern int player_pos;

/** home position of different players */
extern PositionType home[4][3];

/** next home position */
extern int next_home;

/** which vision alg to use */
extern int which_vis;

/** show image */
extern int show_image;

/* variables, flags and datatypes that I have added */

/** Role type - the job of the bot */
enum role_type {ATTACKER, DEFENDER, GOALIE};
typedef enum role_type role;
extern  role MyRole;

/** have  I been told where the ball is? */
extern int told_where_flag;

/** the postion of the ball */
extern PositionType ToldPos;

/** reset to start postion and wait for start */
extern int reset_flag;

/** I just had the ball, now it's gone */
extern int just_lost_flag;

/** Need to check for a wall */
extern int check_wall_flag;


/** Another teammate has the ball */
extern int teammate_has_ball;

/** Where to go on a reset */
extern  PositionType reset_pos;

/** Whether we're waiting for play to start, or are playing */
extern int play_flag;

/** Ball direction info for tracking purposes */
extern float BallDeltaX, BallDeltaY;


/** flag to say whether comms system is used or not */
extern int comms_flag;


/** ImagePos the position of an object in an image */
enum ImagePos {LEFT_EDGE, RIGHT_EDGE, MIDDLE_EDGE};
typedef enum ImagePos image_position;
extern  image_position BallImagePos;

/** Flag to indicate when the obsticle is a wall*/ 
extern int is_wall_flag;

/** Flag to say when to find x,y position */
extern int find_loc_flag;
extern int found_wall_flag;

/** Flags to for goal search */
extern int look_for_goal_flag;
extern int found_goal_flag;


/*@}*/








