/** @name cam.c 

    Display camera picture until end-button is pressed. If camera is
    colour camera, picture is converted to greyscale picture.
    Menu-output: gEnd for greyscale, cEnd for colour camera.

    @author Birgit Graf, UWA, 1998
    @version 1.0   */

/*@{*/


#include "librobi/librobi.h"
#include "libimpro/improc.h"
#include "librobi/protos.h"

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "types.h"
#include "const.h" 
#include "kern.h"
#include "vw.h"
#include "hdt.h"
#include "hdt_sem.h"

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


/** picture to work on */
colimage img;
/** picture for LCD-output */
image greyimg;

/** camera version */
int camera;
  

/*************************************************************************/
/** Error message.
    Print error message and end program.

    @param str string, which should be printed
    @return void */
/*************************************************************************/

void error(char *str)
{
  printf("ERROR: %s\n",str);
  OSWait(200);
  exit(0);
}



/*************************************************************************/
/** Run program.
    Display camera picture until end-button is pressed. */
/*************************************************************************/

void main()
{
  camera=CAMInit(WIDE);
  if (camera==NOCAM)
    error("No camera!\n");
  else
    if (camera==INITERROR)
      error("CAMInit!\n");

  if (camera<COLCAM)
  { LCDMenu("","","","gEnd");
    CAMMode(AUTOBRIGHTNESS);
  }
  else
    LCDMenu("","","","cEnd");

  while (KEYRead()!=KEY4)
  {
    if (camera<COLCAM)
      CAMGetFrame(&greyimg); 
    else
    {
      CAMGetColFrame(&img,FALSE); 
      IPColor2Grey(&img,&greyimg);
    }
    LCDPutGraphic(&greyimg);  
  }
}
/*@}*/
