#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <pthread.h>
#include <time.h>

#include "forms.h"
#include "protos.h"
#include "kern.h"
#include "eyesim.h"

/* Detect if semaphore is initialized */
#define SEM_MAGIC 0x0F23B97

/* From OSMT.c */
extern BYTE ThreadMode;
 
int
OSSemInit (struct sem *sem, int val)
{
  if(sem==NULL) 
    return -1;

  if ( SEM_MAGIC == sem->magic  ) {
    fprintf(stderr,"OSSemInit: Semaphore already initialized\n");
    return -1;
  }

  sem->count = val;
  pthread_mutex_init(&sem->mutex, NULL);
  pthread_cond_init(&sem->cond, NULL);
  sem->magic = SEM_MAGIC;
  return 0;
}


int
OSSemV(struct sem *sem)
{
  /* No semaphore structure, bad semaphore or not in MT mode */
  if(sem==NULL || sem->magic != SEM_MAGIC || 255 == ThreadMode)
    return -1;

  if ( -1 == pthread_mutex_lock(&sem->mutex) ) {
    fprintf(stderr,"OSSemV: Unable to pthread_mutex_lock\n");
    return -1;
  }
  sem->count++;
  if ( -1 == pthread_mutex_unlock(&sem->mutex) ) {
    fprintf(stderr,"OSSemV: Unable to pthread_mutex_unlock\n");
    return -1;
  }
  if ( -1 == pthread_cond_signal(&sem->cond) ) {
    fprintf(stderr,"OSSemV: Unable to pthread_cond_signal\n");
    return -1;
  }
  sched_yield();
  return 0 ;
}


int
OSSemP(struct sem *sem)
{
  /* No semaphore structure, bad semaphore or not in MT mode */
  if(sem==NULL || sem->magic != SEM_MAGIC || 255 == ThreadMode)
    return -1;

  if ( -1 == pthread_mutex_lock(&sem->mutex) ) {
    fprintf(stderr,"OSSemP: Unable to pthread_mutex_lock\n");
    return -1;
  }
  while(sem->count <= 0) {
    if (-1 == pthread_cond_wait(&sem->cond, &sem->mutex) ) {
      fprintf(stderr,"OSSemP: Unable to pthread_cond_wait\n");
      return -1;
    }
  }
  sem->count--;
  if (-1 == pthread_mutex_unlock(&sem->mutex) ) {
    fprintf(stderr,"OSSemP: Unable to pthread_mutex_unlock\n");
    return -1;
  }
  return 0;
}

